package com.xforceplus.ultraman.app.jcultramanocrdemo.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * operation_enum
 * </p>
 *
 * @author ultraman
 * @since 2024-08-19
 */
public enum OperationEnum {

    CREATE("create", "新增"),
    UPDATE("update", "更新"),
    OPEN("open", "启用"),
    CLOSE("close", "停用");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    OperationEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static OperationEnum fromCode(String code) {
        return Stream.of(OperationEnum.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
