package com.xforceplus.ultraman.app.jcultramanocrdemo.metadata.validator;

import com.xforceplus.ultraman.app.jcultramanocrdemo.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.jcultramanocrdemo.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-08-19
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(AcquireStatus.class)) {
            isValid = null != AcquireStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AcquireStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(OcrChannel.class)) {
            isValid = null != OcrChannel.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OcrChannel.class.getSimpleName());
            }
        }
        if(clazz.equals(ChatContentTypeEnum.class)) {
            isValid = null != ChatContentTypeEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ChatContentTypeEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(EnableEnum.class)) {
            isValid = null != EnableEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, EnableEnum.class.getSimpleName());
            }
        }
        if(clazz.equals(OperationEnum.class)) {
            isValid = null != OperationEnum.fromCode(value);
            if(!isValid) {
                unValidMsg(context, OperationEnum.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
