package com.xforceplus.ultraman.app.jcultramanshenyi.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * buyer_type
 * </p>
 *
 * @author ultraman
 * @since 2024-04-01
 */
public enum BuyerType {

    _1("1", "一般纳税人"),
    _2("2", "小规模纳税人");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    BuyerType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BuyerType fromCode(String code) {
        return Stream.of(BuyerType.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
