package com.xforceplus.ultraman.app.jcultramanshenyi.metadata.dict;

import java.util.stream.Stream;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * pricing_method
 * </p>
 *
 * @author ultraman
 * @since 2024-04-01
 */
public enum PricingMethod {

    _1("1", "含税价"),
    _0("0", "不含税价");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    PricingMethod(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static PricingMethod fromCode(String code) {
        return Stream.of(PricingMethod.values())
                .filter(t -> t.code().equals(code))
                .findFirst().orElse(null);
    }
}
