package com.xforceplus.ultraman.app.jcultramanshenyi.metadata.validator;

import com.xforceplus.ultraman.app.jcultramanshenyi.metadata.validator.annotation.CheckUltramanEnum;

import com.xforceplus.ultraman.app.jcultramanshenyi.metadata.dict.*;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

/**
 * <p>
 * UltramanEnumConstraintValidator
 * </p>
 *
 * @author ultraman
 * @since 2024-04-01
 */
public class UltramanEnumConstraintValidator implements ConstraintValidator<CheckUltramanEnum, String> {

    private final String MSG_FORMAT = "value must be the code of one of enum %s";

    Class clazz;

    @Override
    public void initialize(CheckUltramanEnum constraintAnnotation) {
        clazz = constraintAnnotation.value();
    }

    @Override
    public boolean isValid(String value, ConstraintValidatorContext context) {
        if(null == value || value.length() == 0) {
            return true;
        }

        boolean isValid = true;

        if(clazz.equals(FlowStatus.class)) {
            isValid = null != FlowStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, FlowStatus.class.getSimpleName());
            }
        }
        if(clazz.equals(SnapshotFormat.class)) {
            isValid = null != SnapshotFormat.fromCode(value);
            if(!isValid) {
                unValidMsg(context, SnapshotFormat.class.getSimpleName());
            }
        }
        if(clazz.equals(ZeroTax.class)) {
            isValid = null != ZeroTax.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ZeroTax.class.getSimpleName());
            }
        }
        if(clazz.equals(TaxPre.class)) {
            isValid = null != TaxPre.fromCode(value);
            if(!isValid) {
                unValidMsg(context, TaxPre.class.getSimpleName());
            }
        }
        if(clazz.equals(InvoiceType.class)) {
            isValid = null != InvoiceType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, InvoiceType.class.getSimpleName());
            }
        }
        if(clazz.equals(PricingMethod.class)) {
            isValid = null != PricingMethod.fromCode(value);
            if(!isValid) {
                unValidMsg(context, PricingMethod.class.getSimpleName());
            }
        }
        if(clazz.equals(AccountType.class)) {
            isValid = null != AccountType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, AccountType.class.getSimpleName());
            }
        }
        if(clazz.equals(BuyerType.class)) {
            isValid = null != BuyerType.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BuyerType.class.getSimpleName());
            }
        }
        if(clazz.equals(ZeroTax.class)) {
            isValid = null != ZeroTax.fromCode(value);
            if(!isValid) {
                unValidMsg(context, ZeroTax.class.getSimpleName());
            }
        }
        if(clazz.equals(Status.class)) {
            isValid = null != Status.fromCode(value);
            if(!isValid) {
                unValidMsg(context, Status.class.getSimpleName());
            }
        }
        if(clazz.equals(BizOrderStatus.class)) {
            isValid = null != BizOrderStatus.fromCode(value);
            if(!isValid) {
                unValidMsg(context, BizOrderStatus.class.getSimpleName());
            }
        }

        return isValid;
    }

    private void unValidMsg(ConstraintValidatorContext context, String enumName){
        context.disableDefaultConstraintViolation();
        context.buildConstraintViolationWithTemplate(
                String.format(MSG_FORMAT, enumName))
                .addConstraintViolation();
    }
}
