package com.xforceplus.ultraman.app.jcultramantongjunxian.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcultramantongjunxian.entity.SalesBillDetailTjx;
import com.xforceplus.ultraman.app.jcultramantongjunxian.service.ISalesBillDetailTjxService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 销项业务单明细前端控制器
 *
 * @author ultraman
 * @date 2024-03-29
 */
@RestController
public class SalesBillDetailTjxController {

  @Autowired
  private ISalesBillDetailTjxService salesBillDetailTjxServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param salesBillDetailTjx 销项业务单明细
   * @return
   */
  @GetMapping("/salesbilldetailtjxs" )
  public XfR getSalesBillDetailTjxs(XfPage page, SalesBillDetailTjx salesBillDetailTjx) {
    return XfR.ok(salesBillDetailTjxServiceImpl.page(page, Wrappers.query(salesBillDetailTjx)));
  }

  /**
   * 通过id查询销项业务单明细
   * @param  id
   * @return XfR
   */
  @GetMapping("/salesbilldetailtjxs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(salesBillDetailTjxServiceImpl.getById(id));
  }

  /**
   * 新增销项业务单明细
   * @param salesBillDetailTjx 销项业务单明细
   * @return XfR
   */
  @PostMapping("/salesbilldetailtjxs")
  public XfR save(@RequestBody SalesBillDetailTjx salesBillDetailTjx) {
     return XfR.ok(salesBillDetailTjxServiceImpl.save(salesBillDetailTjx));
  }

  /**
   * 修改-传入修改后的全部数据销项业务单明细
   * @param salesBillDetailTjx 销项业务单明细
   * @return XfR
   */
  @PutMapping("/salesbilldetailtjxs/{id}")
  public XfR putUpdate(@RequestBody SalesBillDetailTjx salesBillDetailTjx,@PathVariable Long id) {
      salesBillDetailTjx.setId(id);
      return XfR.ok(salesBillDetailTjxServiceImpl.updateById(salesBillDetailTjx));
  }

  /**
   * 修改-传入修改的数据销项业务单明细
   * @param salesBillDetailTjx 销项业务单明细
   * @return XfR
   */
  @PatchMapping("/salesbilldetailtjxs/{id}")
  public XfR patchUpdate(@RequestBody SalesBillDetailTjx salesBillDetailTjx,@PathVariable Long id) {
      SalesBillDetailTjx upsalesBillDetailTjx = salesBillDetailTjxServiceImpl.getById(id);
      if(upsalesBillDetailTjx != null){
        upsalesBillDetailTjx = ObjectCopyUtils.copyProperties(salesBillDetailTjx,upsalesBillDetailTjx,true);
      }
      return XfR.ok(salesBillDetailTjxServiceImpl.updateById(upsalesBillDetailTjx));
  }

  /**
   * 通过id删除销项业务单明细
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/salesbilldetailtjxs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(salesBillDetailTjxServiceImpl.removeById(id));
  }

  @PostMapping("/salesbilldetailtjxs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sales_bill_detail_tjx");
     params.put("request", condition);

     return XfR.ok(salesBillDetailTjxServiceImpl.querys(params));
  }

}
