package com.xforceplus.ultraman.app.jcultramantongjunxian.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcultramantongjunxian.entity.SellerInvoiceDetailsTjx;
import com.xforceplus.ultraman.app.jcultramantongjunxian.service.ISellerInvoiceDetailsTjxService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 销项发票明细前端控制器
 *
 * @author ultraman
 * @date 2024-03-29
 */
@RestController
public class SellerInvoiceDetailsTjxController {

  @Autowired
  private ISellerInvoiceDetailsTjxService sellerInvoiceDetailsTjxServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param sellerInvoiceDetailsTjx 销项发票明细
   * @return
   */
  @GetMapping("/sellerinvoicedetailstjxs" )
  public XfR getSellerInvoiceDetailsTjxs(XfPage page, SellerInvoiceDetailsTjx sellerInvoiceDetailsTjx) {
    return XfR.ok(sellerInvoiceDetailsTjxServiceImpl.page(page, Wrappers.query(sellerInvoiceDetailsTjx)));
  }

  /**
   * 通过id查询销项发票明细
   * @param  id
   * @return XfR
   */
  @GetMapping("/sellerinvoicedetailstjxs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(sellerInvoiceDetailsTjxServiceImpl.getById(id));
  }

  /**
   * 新增销项发票明细
   * @param sellerInvoiceDetailsTjx 销项发票明细
   * @return XfR
   */
  @PostMapping("/sellerinvoicedetailstjxs")
  public XfR save(@RequestBody SellerInvoiceDetailsTjx sellerInvoiceDetailsTjx) {
     return XfR.ok(sellerInvoiceDetailsTjxServiceImpl.save(sellerInvoiceDetailsTjx));
  }

  /**
   * 修改-传入修改后的全部数据销项发票明细
   * @param sellerInvoiceDetailsTjx 销项发票明细
   * @return XfR
   */
  @PutMapping("/sellerinvoicedetailstjxs/{id}")
  public XfR putUpdate(@RequestBody SellerInvoiceDetailsTjx sellerInvoiceDetailsTjx,@PathVariable Long id) {
      sellerInvoiceDetailsTjx.setId(id);
      return XfR.ok(sellerInvoiceDetailsTjxServiceImpl.updateById(sellerInvoiceDetailsTjx));
  }

  /**
   * 修改-传入修改的数据销项发票明细
   * @param sellerInvoiceDetailsTjx 销项发票明细
   * @return XfR
   */
  @PatchMapping("/sellerinvoicedetailstjxs/{id}")
  public XfR patchUpdate(@RequestBody SellerInvoiceDetailsTjx sellerInvoiceDetailsTjx,@PathVariable Long id) {
      SellerInvoiceDetailsTjx upsellerInvoiceDetailsTjx = sellerInvoiceDetailsTjxServiceImpl.getById(id);
      if(upsellerInvoiceDetailsTjx != null){
        upsellerInvoiceDetailsTjx = ObjectCopyUtils.copyProperties(sellerInvoiceDetailsTjx,upsellerInvoiceDetailsTjx,true);
      }
      return XfR.ok(sellerInvoiceDetailsTjxServiceImpl.updateById(upsellerInvoiceDetailsTjx));
  }

  /**
   * 通过id删除销项发票明细
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/sellerinvoicedetailstjxs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(sellerInvoiceDetailsTjxServiceImpl.removeById(id));
  }

  @PostMapping("/sellerinvoicedetailstjxs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "seller_invoice_details_tjx");
     params.put("request", condition);

     return XfR.ok(sellerInvoiceDetailsTjxServiceImpl.querys(params));
  }

}
