package com.xforceplus.ultraman.app.jcultramantongjunxian.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcultramantongjunxian.entity.SellerInvoiceMainTjx;
import com.xforceplus.ultraman.app.jcultramantongjunxian.service.ISellerInvoiceMainTjxService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 销项发票主信息前端控制器
 *
 * @author ultraman
 * @date 2024-03-29
 */
@RestController
public class SellerInvoiceMainTjxController {

  @Autowired
  private ISellerInvoiceMainTjxService sellerInvoiceMainTjxServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param sellerInvoiceMainTjx 销项发票主信息
   * @return
   */
  @GetMapping("/sellerinvoicemaintjxs" )
  public XfR getSellerInvoiceMainTjxs(XfPage page, SellerInvoiceMainTjx sellerInvoiceMainTjx) {
    return XfR.ok(sellerInvoiceMainTjxServiceImpl.page(page, Wrappers.query(sellerInvoiceMainTjx)));
  }

  /**
   * 通过id查询销项发票主信息
   * @param  id
   * @return XfR
   */
  @GetMapping("/sellerinvoicemaintjxs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(sellerInvoiceMainTjxServiceImpl.getById(id));
  }

  /**
   * 新增销项发票主信息
   * @param sellerInvoiceMainTjx 销项发票主信息
   * @return XfR
   */
  @PostMapping("/sellerinvoicemaintjxs")
  public XfR save(@RequestBody SellerInvoiceMainTjx sellerInvoiceMainTjx) {
     return XfR.ok(sellerInvoiceMainTjxServiceImpl.save(sellerInvoiceMainTjx));
  }

  /**
   * 修改-传入修改后的全部数据销项发票主信息
   * @param sellerInvoiceMainTjx 销项发票主信息
   * @return XfR
   */
  @PutMapping("/sellerinvoicemaintjxs/{id}")
  public XfR putUpdate(@RequestBody SellerInvoiceMainTjx sellerInvoiceMainTjx,@PathVariable Long id) {
      sellerInvoiceMainTjx.setId(id);
      return XfR.ok(sellerInvoiceMainTjxServiceImpl.updateById(sellerInvoiceMainTjx));
  }

  /**
   * 修改-传入修改的数据销项发票主信息
   * @param sellerInvoiceMainTjx 销项发票主信息
   * @return XfR
   */
  @PatchMapping("/sellerinvoicemaintjxs/{id}")
  public XfR patchUpdate(@RequestBody SellerInvoiceMainTjx sellerInvoiceMainTjx,@PathVariable Long id) {
      SellerInvoiceMainTjx upsellerInvoiceMainTjx = sellerInvoiceMainTjxServiceImpl.getById(id);
      if(upsellerInvoiceMainTjx != null){
        upsellerInvoiceMainTjx = ObjectCopyUtils.copyProperties(sellerInvoiceMainTjx,upsellerInvoiceMainTjx,true);
      }
      return XfR.ok(sellerInvoiceMainTjxServiceImpl.updateById(upsellerInvoiceMainTjx));
  }

  /**
   * 通过id删除销项发票主信息
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/sellerinvoicemaintjxs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(sellerInvoiceMainTjxServiceImpl.removeById(id));
  }

  @PostMapping("/sellerinvoicemaintjxs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "seller_invoice_main_tjx");
     params.put("request", condition);

     return XfR.ok(sellerInvoiceMainTjxServiceImpl.querys(params));
  }

}
