package com.xforceplus.ultraman.app.jcultramantongjunxian.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcultramantongjunxian.entity.SalesBilMainTjx;
import com.xforceplus.ultraman.app.jcultramantongjunxian.service.ISalesBilMainTjxService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * 销项业务单前端控制器
 *
 * @author ultraman
 * @date 2024-04-01
 */
@RestController
public class SalesBilMainTjxController {

  @Autowired
  private ISalesBilMainTjxService salesBilMainTjxServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param salesBilMainTjx 销项业务单
   * @return
   */
  @GetMapping("/salesbilmaintjxs" )
  public XfR getSalesBilMainTjxs(XfPage page, SalesBilMainTjx salesBilMainTjx) {
    return XfR.ok(salesBilMainTjxServiceImpl.page(page, Wrappers.query(salesBilMainTjx)));
  }

  /**
   * 通过id查询销项业务单
   * @param  id
   * @return XfR
   */
  @GetMapping("/salesbilmaintjxs/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(salesBilMainTjxServiceImpl.getById(id));
  }

  /**
   * 新增销项业务单
   * @param salesBilMainTjx 销项业务单
   * @return XfR
   */
  @PostMapping("/salesbilmaintjxs")
  public XfR save(@RequestBody SalesBilMainTjx salesBilMainTjx) {
     return XfR.ok(salesBilMainTjxServiceImpl.save(salesBilMainTjx));
  }

  /**
   * 修改-传入修改后的全部数据销项业务单
   * @param salesBilMainTjx 销项业务单
   * @return XfR
   */
  @PutMapping("/salesbilmaintjxs/{id}")
  public XfR putUpdate(@RequestBody SalesBilMainTjx salesBilMainTjx,@PathVariable Long id) {
      salesBilMainTjx.setId(id);
      return XfR.ok(salesBilMainTjxServiceImpl.updateById(salesBilMainTjx));
  }

  /**
   * 修改-传入修改的数据销项业务单
   * @param salesBilMainTjx 销项业务单
   * @return XfR
   */
  @PatchMapping("/salesbilmaintjxs/{id}")
  public XfR patchUpdate(@RequestBody SalesBilMainTjx salesBilMainTjx,@PathVariable Long id) {
      SalesBilMainTjx upsalesBilMainTjx = salesBilMainTjxServiceImpl.getById(id);
      if(upsalesBilMainTjx != null){
        upsalesBilMainTjx = ObjectCopyUtils.copyProperties(salesBilMainTjx,upsalesBilMainTjx,true);
      }
      return XfR.ok(salesBilMainTjxServiceImpl.updateById(upsalesBilMainTjx));
  }

  /**
   * 通过id删除销项业务单
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/salesbilmaintjxs/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(salesBilMainTjxServiceImpl.removeById(id));
  }

  @PostMapping("/salesbilmaintjxs/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sales_bil_main_tjx");
     params.put("request", condition);

     return XfR.ok(salesBilMainTjxServiceImpl.querys(params));
  }

}
