package com.xforceplus.ultraman.app.jcultramanxuyy.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * account_type
 * </p>
 *
 * @author ultraman
 * @since 2024-03-29
 */
public enum AccountType {

    AP("AP", "购方"),
    AR("AR", "销方");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    AccountType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AccountType fromCode(String code){
        switch(code) {
            case "AP":
                return AP;
            case "AR":
                return AR;
            default:
                return null;
        }
    }
}
