package com.xforceplus.ultraman.app.jcultramanxuyy.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * biz_order_status
 * </p>
 *
 * @author ultraman
 * @since 2024-03-29
 */
public enum BizOrderStatus {

    _01("01", "待审批"),
    _02("02", "待开票"),
    _03("03", "已开票"),
    _00("00", "上传失败"),
    _04("04", "作废");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BizOrderStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BizOrderStatus fromCode(String code){
        switch(code) {
            case "01":
                return _01;
            case "02":
                return _02;
            case "03":
                return _03;
            case "00":
                return _00;
            case "04":
                return _04;
            default:
                return null;
        }
    }
}
