package com.xforceplus.ultraman.app.jcultramanxuyy.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * invoice_type
 * </p>
 *
 * @author ultraman
 * @since 2024-03-29
 */
public enum InvoiceType {

    S("s", "增值税专用发票"),
    C("c", "增值税普通发票"),
    SE("se", "增值税电子专用发票"),
    CE("ce", "增值税电子普通发票（含区块链）"),
    QC("qc", "全电增值税电子普通发票"),
    QS("qs", "全电增值税电子专用发票"),
    CZ("cz", "全电增值税纸质普通发票"),
    SZ("sz", "全电增值税纸质专用发票");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    InvoiceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceType fromCode(String code){
        switch(code) {
            case "s":
                return S;
            case "c":
                return C;
            case "se":
                return SE;
            case "ce":
                return CE;
            case "qc":
                return QC;
            case "qs":
                return QS;
            case "cz":
                return CZ;
            case "sz":
                return SZ;
            default:
                return null;
        }
    }
}
