package com.xforceplus.ultraman.app.jcultramanyh.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * audit_status
 * </p>
 *
 * @author ultraman
 * @since 2024-04-03
 */
public enum AuditStatus {

    _5("5", "取消审批申请"),
    _6("6", "请求sap锁单"),
    _7("7", "标识单据为业务单模式(不会被协同线同步逻辑给刷掉)"),
    _1("1", "未审核"),
    _2("2", "审核中"),
    _3("3", "审核通过"),
    _4("4", "审核不通过");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    AuditStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static AuditStatus fromCode(String code){
        switch(code) {
            case "5":
                return _5;
            case "6":
                return _6;
            case "7":
                return _7;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "4":
                return _4;
            default:
                return null;
        }
    }
}
