package com.xforceplus.ultraman.app.jcultramanyh.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * business_bill_type
 * </p>
 *
 * @author ultraman
 * @since 2024-04-03
 */
public enum BusinessBillType {

    AR("AR", "销项单据"),
    AP("AP", "进项单据");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BusinessBillType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BusinessBillType fromCode(String code){
        switch(code) {
            case "AR":
                return AR;
            case "AP":
                return AP;
            default:
                return null;
        }
    }
}
