package com.xforceplus.ultraman.app.jcultramanyh.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * cooperate_modify_status
 * </p>
 *
 * @author ultraman
 * @since 2024-04-03
 */
public enum CooperateModifyStatus {

    _0("0", "未被修改过"),
    _1("1", "被修改过");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    CooperateModifyStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CooperateModifyStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            default:
                return null;
        }
    }
}
