package com.xforceplus.ultraman.app.jcunileverbpi.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2024-10-17
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcunileverbpi.entity.MonthlyGoal;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-unilever-bpi")
public interface MonthlyGoalFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/monthlyGoal/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param monthlyGoal ${table.comment}
   * @return R
   */
  @PostMapping("/monthlyGoal/add")
  public R save(@RequestBody MonthlyGoal monthlyGoal);

  /**
   * 修改${table.comment}
   * @param monthlyGoal ${table.comment}
   * @return R
   */
  @PostMapping("/monthlyGoal/update")
  public R updateById(@RequestBody MonthlyGoal monthlyGoal);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/monthlyGoal/del/{id}" )
  public R removeById(@PathVariable Long id);

}