package com.xforceplus.ultraman.app.jcunileverbpi.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-12-24
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class JdMakeOrderBookingDetail implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 工厂 
   */
  private String factory;

  /**
   * 客户仓库
   */
  @TableField("customerWarehouse")
  private String customerWarehouse;

  /**
   * JD订单号
   */
  @TableField("jdOrderNo")
  private String jdOrderNo;

  /**
   * SAP订单号
   */
  @TableField("sapOrderNo")
  private String sapOrderNo;

  /**
   * OBD
   */
  private String obd;

  /**
   * 订单箱数
   */
  @TableField("orderBoxCount")
  private String orderBoxCount;

  /**
   * 订单量
   */
  @TableField("orderQuantity")
  private String orderQuantity;

  /**
   * 订单件数
   */
  @TableField("orderPieces")
  private String orderPieces;

  /**
   * 拍数
   */
  private String beat;

  /**
   * 体积
   */
  private String volume;

  /**
   * RDD
   */
  private String rdd;

  /**
   * 订单金额
   */
  @TableField("orderAmount")
  private String orderAmount;

  /**
   * 做单金额
   */
  @TableField("makeOrderAmount")
  private String makeOrderAmount;

  /**
   * 预约日期
   */
  @TableField("bookingDate")
  private String bookingDate;

  /**
   * 预约号
   */
  @TableField("bookingNo")
  private String bookingNo;

  /**
   * 预约时间
   */
  @TableField("bookingTime")
  private String bookingTime;

  /**
   * SAP上单日期
   */
  @TableField("sapLastOrderDate")
  private String sapLastOrderDate;

  /**
   * 预约状态
   */
  @TableField("bookingStatus")
  private String bookingStatus;

  /**
   * 已开票订单
   */
  @TableField("makeInvoiceOrder")
  private String makeInvoiceOrder;

  /**
   * 线下预约日期
   */
  @TableField("offLineBookingDate")
  private String offLineBookingDate;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 组织树
   */
  private String orgTree;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("factory", factory);
      map.put("customerWarehouse", customerWarehouse);
      map.put("jdOrderNo", jdOrderNo);
      map.put("sapOrderNo", sapOrderNo);
      map.put("obd", obd);
      map.put("orderBoxCount", orderBoxCount);
      map.put("orderQuantity", orderQuantity);
      map.put("orderPieces", orderPieces);
      map.put("beat", beat);
      map.put("volume", volume);
      map.put("rdd", rdd);
      map.put("orderAmount", orderAmount);
      map.put("makeOrderAmount", makeOrderAmount);
      map.put("bookingDate", bookingDate);
      map.put("bookingNo", bookingNo);
      map.put("bookingTime", bookingTime);
      map.put("sapLastOrderDate", sapLastOrderDate);
      map.put("bookingStatus", bookingStatus);
      map.put("makeInvoiceOrder", makeInvoiceOrder);
      map.put("offLineBookingDate", offLineBookingDate);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("org_tree", orgTree);

      return map;
  }

  public static JdMakeOrderBookingDetail fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    JdMakeOrderBookingDetail entity = new JdMakeOrderBookingDetail();
    if(map.containsKey("factory")) {
      Object obj = map.get("factory");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFactory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerWarehouse")) {
      Object obj = map.get("customerWarehouse");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerWarehouse((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jdOrderNo")) {
      Object obj = map.get("jdOrderNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJdOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sapOrderNo")) {
      Object obj = map.get("sapOrderNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSapOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("obd")) {
      Object obj = map.get("obd");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setObd((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderBoxCount")) {
      Object obj = map.get("orderBoxCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderBoxCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderQuantity")) {
      Object obj = map.get("orderQuantity");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderQuantity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderPieces")) {
      Object obj = map.get("orderPieces");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderPieces((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("beat")) {
      Object obj = map.get("beat");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBeat((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("volume")) {
      Object obj = map.get("volume");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVolume((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rdd")) {
      Object obj = map.get("rdd");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRdd((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderAmount")) {
      Object obj = map.get("orderAmount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("makeOrderAmount")) {
      Object obj = map.get("makeOrderAmount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMakeOrderAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bookingDate")) {
      Object obj = map.get("bookingDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBookingDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bookingNo")) {
      Object obj = map.get("bookingNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBookingNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bookingTime")) {
      Object obj = map.get("bookingTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBookingTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sapLastOrderDate")) {
      Object obj = map.get("sapLastOrderDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSapLastOrderDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bookingStatus")) {
      Object obj = map.get("bookingStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBookingStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("makeInvoiceOrder")) {
      Object obj = map.get("makeInvoiceOrder");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMakeInvoiceOrder((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("offLineBookingDate")) {
      Object obj = map.get("offLineBookingDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOffLineBookingDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("factory")) {
      Object obj = map.get("factory");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFactory((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customerWarehouse")) {
      Object obj = map.get("customerWarehouse");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerWarehouse((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("jdOrderNo")) {
      Object obj = map.get("jdOrderNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setJdOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sapOrderNo")) {
      Object obj = map.get("sapOrderNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSapOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("obd")) {
      Object obj = map.get("obd");
      if(obj != null) {
        if(obj instanceof String) {
          this.setObd((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orderBoxCount")) {
      Object obj = map.get("orderBoxCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderBoxCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orderQuantity")) {
      Object obj = map.get("orderQuantity");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderQuantity((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orderPieces")) {
      Object obj = map.get("orderPieces");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderPieces((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("beat")) {
      Object obj = map.get("beat");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBeat((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("volume")) {
      Object obj = map.get("volume");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVolume((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("rdd")) {
      Object obj = map.get("rdd");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRdd((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orderAmount")) {
      Object obj = map.get("orderAmount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("makeOrderAmount")) {
      Object obj = map.get("makeOrderAmount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMakeOrderAmount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bookingDate")) {
      Object obj = map.get("bookingDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBookingDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bookingNo")) {
      Object obj = map.get("bookingNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBookingNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bookingTime")) {
      Object obj = map.get("bookingTime");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBookingTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sapLastOrderDate")) {
      Object obj = map.get("sapLastOrderDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSapLastOrderDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bookingStatus")) {
      Object obj = map.get("bookingStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBookingStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("makeInvoiceOrder")) {
      Object obj = map.get("makeInvoiceOrder");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMakeInvoiceOrder((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("offLineBookingDate")) {
      Object obj = map.get("offLineBookingDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOffLineBookingDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
  }
}
