package com.xforceplus.ultraman.app.jcunileverbpi.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-12-24
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OkMonthlyQuota implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 品牌
   */
  private String brand;

  /**
   * 分类
   */
  private String category;

  /**
   * DU code
   */
  @TableField("duCode")
  private String duCode;

  /**
   * 产品
   */
  private String product;

  /**
   * 规格
   */
  private String spec;

  /**
   * 开仓日期
   */
  @TableField("openWarehouseDate")
  private String openWarehouseDate;

  /**
   * 重点单品标记
   */
  @TableField("keyItemslabel")
  private String keyItemslabel;

  /**
   * 拍数
   */
  private String beat;

  /**
   * 未税箱价
   */
  @TableField("untaxedBoxPrice")
  private BigDecimal untaxedBoxPrice;

  /**
   * TTL
   */
  private String ttl;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 上海南仓
   */
  @TableField("shanghaiWarehouse")
  private String shanghaiWarehouse;

  /**
   * 南京仓
   */
  @TableField("nanjingWarehouse")
  private String nanjingWarehouse;

  /**
   * 北京仓
   */
  @TableField("beijingWarehouse")
  private String beijingWarehouse;

  /**
   * 山东仓
   */
  @TableField("shandongWarehouse")
  private String shandongWarehouse;

  /**
   * 广州仓
   */
  @TableField("guangzhouWarehouse")
  private String guangzhouWarehouse;

  /**
   * 成都仓
   */
  @TableField("chengduWarehouse")
  private String chengduWarehouse;

  /**
   * 武汉仓
   */
  @TableField("wuhanWarehouse")
  private String wuhanWarehouse;

  /**
   * 太仓仓
   */
  @TableField("taicangWarehouse")
  private String taicangWarehouse;

  /**
   * 组织树
   */
  private String orgTree;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("brand", brand);
      map.put("category", category);
      map.put("duCode", duCode);
      map.put("product", product);
      map.put("spec", spec);
      map.put("openWarehouseDate", openWarehouseDate);
      map.put("keyItemslabel", keyItemslabel);
      map.put("beat", beat);
      map.put("untaxedBoxPrice", untaxedBoxPrice);
      map.put("ttl", ttl);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("shanghaiWarehouse", shanghaiWarehouse);
      map.put("nanjingWarehouse", nanjingWarehouse);
      map.put("beijingWarehouse", beijingWarehouse);
      map.put("shandongWarehouse", shandongWarehouse);
      map.put("guangzhouWarehouse", guangzhouWarehouse);
      map.put("chengduWarehouse", chengduWarehouse);
      map.put("wuhanWarehouse", wuhanWarehouse);
      map.put("taicangWarehouse", taicangWarehouse);
      map.put("org_tree", orgTree);

      return map;
  }

  public static OkMonthlyQuota fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    OkMonthlyQuota entity = new OkMonthlyQuota();
    if(map.containsKey("brand")) {
      Object obj = map.get("brand");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBrand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("category")) {
      Object obj = map.get("category");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCategory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("duCode")) {
      Object obj = map.get("duCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDuCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("product")) {
      Object obj = map.get("product");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProduct((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("spec")) {
      Object obj = map.get("spec");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSpec((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("openWarehouseDate")) {
      Object obj = map.get("openWarehouseDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOpenWarehouseDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("keyItemslabel")) {
      Object obj = map.get("keyItemslabel");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setKeyItemslabel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("beat")) {
      Object obj = map.get("beat");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBeat((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("untaxedBoxPrice")) {
      Object obj = map.get("untaxedBoxPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setUntaxedBoxPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setUntaxedBoxPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setUntaxedBoxPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUntaxedBoxPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUntaxedBoxPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("ttl")) {
      Object obj = map.get("ttl");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTtl((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shanghaiWarehouse")) {
      Object obj = map.get("shanghaiWarehouse");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShanghaiWarehouse((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("nanjingWarehouse")) {
      Object obj = map.get("nanjingWarehouse");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNanjingWarehouse((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("beijingWarehouse")) {
      Object obj = map.get("beijingWarehouse");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBeijingWarehouse((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shandongWarehouse")) {
      Object obj = map.get("shandongWarehouse");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShandongWarehouse((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("guangzhouWarehouse")) {
      Object obj = map.get("guangzhouWarehouse");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGuangzhouWarehouse((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("chengduWarehouse")) {
      Object obj = map.get("chengduWarehouse");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setChengduWarehouse((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("wuhanWarehouse")) {
      Object obj = map.get("wuhanWarehouse");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWuhanWarehouse((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taicangWarehouse")) {
      Object obj = map.get("taicangWarehouse");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaicangWarehouse((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("brand")) {
      Object obj = map.get("brand");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBrand((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("category")) {
      Object obj = map.get("category");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCategory((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("duCode")) {
      Object obj = map.get("duCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDuCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("product")) {
      Object obj = map.get("product");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProduct((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("spec")) {
      Object obj = map.get("spec");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSpec((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("openWarehouseDate")) {
      Object obj = map.get("openWarehouseDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOpenWarehouseDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("keyItemslabel")) {
      Object obj = map.get("keyItemslabel");
      if(obj != null) {
        if(obj instanceof String) {
          this.setKeyItemslabel((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("beat")) {
      Object obj = map.get("beat");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBeat((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("untaxedBoxPrice")) {
      Object obj = map.get("untaxedBoxPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setUntaxedBoxPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setUntaxedBoxPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setUntaxedBoxPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUntaxedBoxPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setUntaxedBoxPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("ttl")) {
      Object obj = map.get("ttl");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTtl((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shanghaiWarehouse")) {
      Object obj = map.get("shanghaiWarehouse");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShanghaiWarehouse((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("nanjingWarehouse")) {
      Object obj = map.get("nanjingWarehouse");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNanjingWarehouse((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("beijingWarehouse")) {
      Object obj = map.get("beijingWarehouse");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBeijingWarehouse((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shandongWarehouse")) {
      Object obj = map.get("shandongWarehouse");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShandongWarehouse((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("guangzhouWarehouse")) {
      Object obj = map.get("guangzhouWarehouse");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGuangzhouWarehouse((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("chengduWarehouse")) {
      Object obj = map.get("chengduWarehouse");
      if(obj != null) {
        if(obj instanceof String) {
          this.setChengduWarehouse((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("wuhanWarehouse")) {
      Object obj = map.get("wuhanWarehouse");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWuhanWarehouse((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taicangWarehouse")) {
      Object obj = map.get("taicangWarehouse");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaicangWarehouse((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
  }
}
