package com.xforceplus.ultraman.app.jcunileverbpi.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-12-24
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class PastYearOrderDetail implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 采购单号
   */
  @TableField("orderNo")
  private String orderNo;

  /**
   * 采购渠道
   */
  @TableField("purchaserChannels")
  private String purchaserChannels;

  /**
   * 合同主体
   */
  @TableField("contractSubject")
  private String contractSubject;

  /**
   * 供应商简码
   */
  @TableField("supplierCode")
  private String supplierCode;

  /**
   * 供应商名称
   */
  @TableField("supplierName")
  private String supplierName;

  /**
   * 商品编号
   */
  @TableField("goodsCode")
  private String goodsCode;

  /**
   * 商品名称
   */
  @TableField("goodsName")
  private String goodsName;

  /**
   * 订单属性
   */
  @TableField("orderAttribute")
  private String orderAttribute;

  /**
   * 配送中心
   */
  @TableField("distributionCenter")
  private String distributionCenter;

  /**
   * 京东仓库
   */
  @TableField("jdWarehouse")
  private String jdWarehouse;

  /**
   * 收货负责人
   */
  @TableField("receivingOfficer")
  private String receivingOfficer;

  /**
   * 收货电话
   */
  @TableField("receivingPhone")
  private String receivingPhone;

  /**
   * 采购价格
   */
  private BigDecimal price;

  /**
   * 原始采购数量
   */
  @TableField("originalQuantity")
  private BigDecimal originalQuantity;

  /**
   * 采购数量
   */
  private BigDecimal quantity;

  /**
   * 实收数量
   */
  @TableField("quantityReceived")
  private BigDecimal quantityReceived;

  /**
   * 贴码建议
   */
  @TableField("labelingSuggestion")
  private String labelingSuggestion;

  /**
   * 京东贴码数量
   */
  @TableField("jdStickerNumber")
  private BigDecimal jdStickerNumber;

  /**
   * 重码UPC
   */
  @TableField("upcRepeat")
  private String upcRepeat;

  /**
   * UPC码
   */
  @TableField("upcCode")
  private String upcCode;

  /**
   * 采购金额
   */
  private BigDecimal amount;

  /**
   * 实收金额
   */
  @TableField("amountReceived")
  private BigDecimal amountReceived;

  /**
   * 采购单位
   */
  private String unit;

  /**
   * 币种
   */
  private String currency;

  /**
   * 采购员
   */
  private String buyer;

  /**
   * 建单人
   */
  @TableField("buildName")
  private String buildName;

  /**
   * 订单状态
   */
  @TableField("orderStatus")
  private String orderStatus;

  /**
   * 订购时间
   */
  @TableField("orderTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime orderTime;

  /**
   * 入库时间
   */
  @TableField("databaseTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime databaseTime;

  /**
   * 预约时间
   */
  @TableField("appointmentTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime appointmentTime;

  /**
   * 预计关单时间
   */
  @TableField("expectedCloseTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime expectedCloseTime;

  /**
   * 备注
   */
  private String remark;

  /**
   * 波次数量
   */
  @TableField("wavesNumbe")
  private String wavesNumbe;

  /**
   * 订单来源
   */
  @TableField("orderSource")
  private String orderSource;

  /**
   * 是否期货
   */
  @TableField("isFutures")
  private String isFutures;

  /**
   * 年
   */
  private String year;

  /**
   * 产品季
   */
  @TableField("productSeason")
  private String productSeason;

  /**
   * 客户订单号
   */
  @TableField("customerOrderNumber")
  private String customerOrderNumber;

  /**
   * 是否多次发货
   */
  @TableField("isRepeatShipped")
  private String isRepeatShipped;

  /**
   * 商品属性
   */
  @TableField("goodsAttributes")
  private String goodsAttributes;

  /**
   * 采购场景
   */
  @TableField("shoppingScene")
  private String shoppingScene;

  /**
   * 采购原因
   */
  @TableField("shoppingReason")
  private String shoppingReason;

  /**
   * 供应商库房
   */
  @TableField("supplierWarehouse")
  private String supplierWarehouse;

  /**
   * 供应商库房编码
   */
  @TableField("supplierWarehouseCode")
  private String supplierWarehouseCode;

  /**
   * 物权转移
   */
  @TableField("transferRealRight")
  private String transferRealRight;

  /**
   * 采购类型
   */
  @TableField("orderType")
  private String orderType;

  /**
   * ECLP出库单号
   */
  @TableField("eclpCode")
  private String eclpCode;

  /**
   * 详细地址
   */
  private String address;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 订购时间-2
   */
  @TableField("orderTime2")
  private String orderTime2;

  /**
   * 订购时间-3
   */
  @TableField("orderTime3")
  private String orderTime3;

  /**
   * 预计消化时间
   */
  @TableField("expectedDigestTime")
  private String expectedDigestTime;

  /**
   * 组织树
   */
  private String orgTree;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("orderNo", orderNo);
      map.put("purchaserChannels", purchaserChannels);
      map.put("contractSubject", contractSubject);
      map.put("supplierCode", supplierCode);
      map.put("supplierName", supplierName);
      map.put("goodsCode", goodsCode);
      map.put("goodsName", goodsName);
      map.put("orderAttribute", orderAttribute);
      map.put("distributionCenter", distributionCenter);
      map.put("jdWarehouse", jdWarehouse);
      map.put("receivingOfficer", receivingOfficer);
      map.put("receivingPhone", receivingPhone);
      map.put("price", price);
      map.put("originalQuantity", originalQuantity);
      map.put("quantity", quantity);
      map.put("quantityReceived", quantityReceived);
      map.put("labelingSuggestion", labelingSuggestion);
      map.put("jdStickerNumber", jdStickerNumber);
      map.put("upcRepeat", upcRepeat);
      map.put("upcCode", upcCode);
      map.put("amount", amount);
      map.put("amountReceived", amountReceived);
      map.put("unit", unit);
      map.put("currency", currency);
      map.put("buyer", buyer);
      map.put("buildName", buildName);
      map.put("orderStatus", orderStatus);
      map.put("orderTime", BocpGenUtils.toTimestamp(orderTime));
      map.put("databaseTime", BocpGenUtils.toTimestamp(databaseTime));
      map.put("appointmentTime", BocpGenUtils.toTimestamp(appointmentTime));
      map.put("expectedCloseTime", BocpGenUtils.toTimestamp(expectedCloseTime));
      map.put("remark", remark);
      map.put("wavesNumbe", wavesNumbe);
      map.put("orderSource", orderSource);
      map.put("isFutures", isFutures);
      map.put("year", year);
      map.put("productSeason", productSeason);
      map.put("customerOrderNumber", customerOrderNumber);
      map.put("isRepeatShipped", isRepeatShipped);
      map.put("goodsAttributes", goodsAttributes);
      map.put("shoppingScene", shoppingScene);
      map.put("shoppingReason", shoppingReason);
      map.put("supplierWarehouse", supplierWarehouse);
      map.put("supplierWarehouseCode", supplierWarehouseCode);
      map.put("transferRealRight", transferRealRight);
      map.put("orderType", orderType);
      map.put("eclpCode", eclpCode);
      map.put("address", address);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("orderTime2", orderTime2);
      map.put("orderTime3", orderTime3);
      map.put("expectedDigestTime", expectedDigestTime);
      map.put("org_tree", orgTree);

      return map;
  }

  public static PastYearOrderDetail fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    PastYearOrderDetail entity = new PastYearOrderDetail();
    if(map.containsKey("orderNo")) {
      Object obj = map.get("orderNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserChannels")) {
      Object obj = map.get("purchaserChannels");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPurchaserChannels((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("contractSubject")) {
      Object obj = map.get("contractSubject");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setContractSubject((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierCode")) {
      Object obj = map.get("supplierCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSupplierCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierName")) {
      Object obj = map.get("supplierName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSupplierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goodsCode")) {
      Object obj = map.get("goodsCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goodsName")) {
      Object obj = map.get("goodsName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderAttribute")) {
      Object obj = map.get("orderAttribute");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderAttribute((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distributionCenter")) {
      Object obj = map.get("distributionCenter");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDistributionCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jdWarehouse")) {
      Object obj = map.get("jdWarehouse");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJdWarehouse((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receivingOfficer")) {
      Object obj = map.get("receivingOfficer");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceivingOfficer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("receivingPhone")) {
      Object obj = map.get("receivingPhone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReceivingPhone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("price")) {
      Object obj = map.get("price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("originalQuantity")) {
      Object obj = map.get("originalQuantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOriginalQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOriginalQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOriginalQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOriginalQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOriginalQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("quantityReceived")) {
      Object obj = map.get("quantityReceived");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setQuantityReceived((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setQuantityReceived(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setQuantityReceived(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setQuantityReceived(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setQuantityReceived(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("labelingSuggestion")) {
      Object obj = map.get("labelingSuggestion");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLabelingSuggestion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jdStickerNumber")) {
      Object obj = map.get("jdStickerNumber");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setJdStickerNumber((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setJdStickerNumber(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setJdStickerNumber(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setJdStickerNumber(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setJdStickerNumber(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("upcRepeat")) {
      Object obj = map.get("upcRepeat");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpcRepeat((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("upcCode")) {
      Object obj = map.get("upcCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpcCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("amount")) {
      Object obj = map.get("amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("amountReceived")) {
      Object obj = map.get("amountReceived");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setAmountReceived((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setAmountReceived(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setAmountReceived(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAmountReceived(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setAmountReceived(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCurrency((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buyer")) {
      Object obj = map.get("buyer");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuyer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("buildName")) {
      Object obj = map.get("buildName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBuildName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderStatus")) {
      Object obj = map.get("orderStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderTime")) {
      Object obj = map.get("orderTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrderTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setOrderTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOrderTime(null);
      }
    }
    if(map.containsKey("databaseTime")) {
      Object obj = map.get("databaseTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDatabaseTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setDatabaseTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDatabaseTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDatabaseTime(null);
      }
    }
    if(map.containsKey("appointmentTime")) {
      Object obj = map.get("appointmentTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setAppointmentTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setAppointmentTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setAppointmentTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setAppointmentTime(null);
      }
    }
    if(map.containsKey("expectedCloseTime")) {
      Object obj = map.get("expectedCloseTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setExpectedCloseTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setExpectedCloseTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setExpectedCloseTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setExpectedCloseTime(null);
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("wavesNumbe")) {
      Object obj = map.get("wavesNumbe");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWavesNumbe((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderSource")) {
      Object obj = map.get("orderSource");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderSource((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isFutures")) {
      Object obj = map.get("isFutures");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsFutures((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("year")) {
      Object obj = map.get("year");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setYear((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productSeason")) {
      Object obj = map.get("productSeason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductSeason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customerOrderNumber")) {
      Object obj = map.get("customerOrderNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCustomerOrderNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isRepeatShipped")) {
      Object obj = map.get("isRepeatShipped");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsRepeatShipped((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goodsAttributes")) {
      Object obj = map.get("goodsAttributes");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsAttributes((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shoppingScene")) {
      Object obj = map.get("shoppingScene");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShoppingScene((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shoppingReason")) {
      Object obj = map.get("shoppingReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShoppingReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierWarehouse")) {
      Object obj = map.get("supplierWarehouse");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSupplierWarehouse((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierWarehouseCode")) {
      Object obj = map.get("supplierWarehouseCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSupplierWarehouseCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("transferRealRight")) {
      Object obj = map.get("transferRealRight");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTransferRealRight((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderType")) {
      Object obj = map.get("orderType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("eclpCode")) {
      Object obj = map.get("eclpCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setEclpCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("address")) {
      Object obj = map.get("address");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderTime2")) {
      Object obj = map.get("orderTime2");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderTime2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderTime3")) {
      Object obj = map.get("orderTime3");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderTime3((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("expectedDigestTime")) {
      Object obj = map.get("expectedDigestTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExpectedDigestTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("orderNo")) {
      Object obj = map.get("orderNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("purchaserChannels")) {
      Object obj = map.get("purchaserChannels");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPurchaserChannels((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("contractSubject")) {
      Object obj = map.get("contractSubject");
      if(obj != null) {
        if(obj instanceof String) {
          this.setContractSubject((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("supplierCode")) {
      Object obj = map.get("supplierCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSupplierCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("supplierName")) {
      Object obj = map.get("supplierName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSupplierName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goodsCode")) {
      Object obj = map.get("goodsCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodsCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goodsName")) {
      Object obj = map.get("goodsName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodsName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orderAttribute")) {
      Object obj = map.get("orderAttribute");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderAttribute((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("distributionCenter")) {
      Object obj = map.get("distributionCenter");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDistributionCenter((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("jdWarehouse")) {
      Object obj = map.get("jdWarehouse");
      if(obj != null) {
        if(obj instanceof String) {
          this.setJdWarehouse((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receivingOfficer")) {
      Object obj = map.get("receivingOfficer");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceivingOfficer((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("receivingPhone")) {
      Object obj = map.get("receivingPhone");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReceivingPhone((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("price")) {
      Object obj = map.get("price");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("originalQuantity")) {
      Object obj = map.get("originalQuantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOriginalQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOriginalQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOriginalQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOriginalQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOriginalQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("quantity")) {
      Object obj = map.get("quantity");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setQuantity((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setQuantity(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setQuantity(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setQuantity(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setQuantity(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("quantityReceived")) {
      Object obj = map.get("quantityReceived");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setQuantityReceived((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setQuantityReceived(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setQuantityReceived(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setQuantityReceived(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setQuantityReceived(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("labelingSuggestion")) {
      Object obj = map.get("labelingSuggestion");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLabelingSuggestion((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("jdStickerNumber")) {
      Object obj = map.get("jdStickerNumber");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setJdStickerNumber((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setJdStickerNumber(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setJdStickerNumber(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setJdStickerNumber(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setJdStickerNumber(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("upcRepeat")) {
      Object obj = map.get("upcRepeat");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpcRepeat((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("upcCode")) {
      Object obj = map.get("upcCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpcCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("amount")) {
      Object obj = map.get("amount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("amountReceived")) {
      Object obj = map.get("amountReceived");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setAmountReceived((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setAmountReceived(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setAmountReceived(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAmountReceived(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setAmountReceived(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("unit")) {
      Object obj = map.get("unit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("currency")) {
      Object obj = map.get("currency");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCurrency((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buyer")) {
      Object obj = map.get("buyer");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuyer((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("buildName")) {
      Object obj = map.get("buildName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBuildName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orderStatus")) {
      Object obj = map.get("orderStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orderTime")) {
      Object obj = map.get("orderTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setOrderTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setOrderTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setOrderTime(null);
      }
    }
    if(map.containsKey("databaseTime")) {
      Object obj = map.get("databaseTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDatabaseTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setDatabaseTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDatabaseTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setDatabaseTime(null);
      }
    }
    if(map.containsKey("appointmentTime")) {
      Object obj = map.get("appointmentTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setAppointmentTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setAppointmentTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setAppointmentTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setAppointmentTime(null);
      }
    }
    if(map.containsKey("expectedCloseTime")) {
      Object obj = map.get("expectedCloseTime");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setExpectedCloseTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setExpectedCloseTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setExpectedCloseTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setExpectedCloseTime(null);
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRemark((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("wavesNumbe")) {
      Object obj = map.get("wavesNumbe");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWavesNumbe((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orderSource")) {
      Object obj = map.get("orderSource");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderSource((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("isFutures")) {
      Object obj = map.get("isFutures");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsFutures((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("year")) {
      Object obj = map.get("year");
      if(obj != null) {
        if(obj instanceof String) {
          this.setYear((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("productSeason")) {
      Object obj = map.get("productSeason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProductSeason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customerOrderNumber")) {
      Object obj = map.get("customerOrderNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomerOrderNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("isRepeatShipped")) {
      Object obj = map.get("isRepeatShipped");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsRepeatShipped((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goodsAttributes")) {
      Object obj = map.get("goodsAttributes");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodsAttributes((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shoppingScene")) {
      Object obj = map.get("shoppingScene");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShoppingScene((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shoppingReason")) {
      Object obj = map.get("shoppingReason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShoppingReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("supplierWarehouse")) {
      Object obj = map.get("supplierWarehouse");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSupplierWarehouse((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("supplierWarehouseCode")) {
      Object obj = map.get("supplierWarehouseCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSupplierWarehouseCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("transferRealRight")) {
      Object obj = map.get("transferRealRight");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTransferRealRight((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orderType")) {
      Object obj = map.get("orderType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("eclpCode")) {
      Object obj = map.get("eclpCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEclpCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("address")) {
      Object obj = map.get("address");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orderTime2")) {
      Object obj = map.get("orderTime2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderTime2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orderTime3")) {
      Object obj = map.get("orderTime3");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderTime3((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("expectedDigestTime")) {
      Object obj = map.get("expectedDigestTime");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExpectedDigestTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
  }
}
