package com.xforceplus.ultraman.app.jcunileverbpi.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-12-24
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SmipIce implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * Type
   */
  private String type;

  /**
   * Brand
   */
  private String brand;

  /**
   * Material
   */
  private String material;

  /**
   * Description
   */
  private String description;

  /**
   * SKU Type.1
   */
  @TableField("skuType1")
  private String skuType1;

  /**
   * Plant
   */
  private String plant;

  /**
   * Plant_Des
   */
  @TableField("plantDes")
  private String plantDes;

  /**
   * 库位
   */
  @TableField("warehouseLocation")
  private String warehouseLocation;

  /**
   * 可用库存
   */
  @TableField("availableInventoryCount")
  private String availableInventoryCount;

  /**
   * 质检库存
   */
  @TableField("inspectionInventoryCount")
  private String inspectionInventoryCount;

  /**
   * 质检批次
   */
  private String inspectionbatch;

  /**
   * 在途数量
   */
  @TableField("intransitCount")
  private String intransitCount;

  /**
   * 在途明细
   */
  @TableField("intransitDetail")
  private String intransitDetail;

  /**
   * Open DRP
   */
  @TableField("openDRP")
  private String openDRP;

  /**
   * 3P生产
   */
  @TableField("production3P")
  private String production3P;

  /**
   * DQD.当周生产量
   */
  @TableField("dqdWeekProductionVolume")
  private String dqdWeekProductionVolume;

  /**
   * KPK.当周生产量
   */
  @TableField("kpkWeekProductionVolume")
  private String kpkWeekProductionVolume;

  /**
   * ML.当周生产量
   */
  @TableField("mlWeekProductionVolume")
  private String mlWeekProductionVolume;

  /**
   * ZLC.当周生产量
   */
  @TableField("zlcWeekProductionVolume")
  private String zlcWeekProductionVolume;

  /**
   * 北京生产计划
   */
  @TableField("beijingProductionPlan")
  private String beijingProductionPlan;

  /**
   * 太仓生产计划
   */
  @TableField("taicangProductionPlan")
  private String taicangProductionPlan;

  /**
   * Last Month Sales
   */
  @TableField("lastMonthSales")
  private String lastMonthSales;

  /**
   * Open Order
   */
  @TableField("openOrder")
  private String openOrder;

  /**
   * MTD
   */
  private String mtd;

  /**
   * 锁货量
   */
  @TableField("lockedGoodsCount")
  private String lockedGoodsCount;

  /**
   * 锁货外可用量
   */
  @TableField("lockedGoodsOutsideAvailableCount")
  private String lockedGoodsOutsideAvailableCount;

  /**
   * Capping设置
   */
  @TableField("cappingSet")
  private String cappingSet;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 组织树
   */
  private String orgTree;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("type", type);
      map.put("brand", brand);
      map.put("material", material);
      map.put("description", description);
      map.put("skuType1", skuType1);
      map.put("plant", plant);
      map.put("plantDes", plantDes);
      map.put("warehouseLocation", warehouseLocation);
      map.put("availableInventoryCount", availableInventoryCount);
      map.put("inspectionInventoryCount", inspectionInventoryCount);
      map.put("inspectionbatch", inspectionbatch);
      map.put("intransitCount", intransitCount);
      map.put("intransitDetail", intransitDetail);
      map.put("openDRP", openDRP);
      map.put("production3P", production3P);
      map.put("dqdWeekProductionVolume", dqdWeekProductionVolume);
      map.put("kpkWeekProductionVolume", kpkWeekProductionVolume);
      map.put("mlWeekProductionVolume", mlWeekProductionVolume);
      map.put("zlcWeekProductionVolume", zlcWeekProductionVolume);
      map.put("beijingProductionPlan", beijingProductionPlan);
      map.put("taicangProductionPlan", taicangProductionPlan);
      map.put("lastMonthSales", lastMonthSales);
      map.put("openOrder", openOrder);
      map.put("mtd", mtd);
      map.put("lockedGoodsCount", lockedGoodsCount);
      map.put("lockedGoodsOutsideAvailableCount", lockedGoodsOutsideAvailableCount);
      map.put("cappingSet", cappingSet);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("org_tree", orgTree);

      return map;
  }

  public static SmipIce fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    SmipIce entity = new SmipIce();
    if(map.containsKey("type")) {
      Object obj = map.get("type");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("brand")) {
      Object obj = map.get("brand");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBrand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("material")) {
      Object obj = map.get("material");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMaterial((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("description")) {
      Object obj = map.get("description");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDescription((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("skuType1")) {
      Object obj = map.get("skuType1");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSkuType1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("plant")) {
      Object obj = map.get("plant");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPlant((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("plantDes")) {
      Object obj = map.get("plantDes");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPlantDes((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("warehouseLocation")) {
      Object obj = map.get("warehouseLocation");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWarehouseLocation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("availableInventoryCount")) {
      Object obj = map.get("availableInventoryCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAvailableInventoryCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("inspectionInventoryCount")) {
      Object obj = map.get("inspectionInventoryCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInspectionInventoryCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("inspectionbatch")) {
      Object obj = map.get("inspectionbatch");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInspectionbatch((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("intransitCount")) {
      Object obj = map.get("intransitCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIntransitCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("intransitDetail")) {
      Object obj = map.get("intransitDetail");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIntransitDetail((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("openDRP")) {
      Object obj = map.get("openDRP");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOpenDRP((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("production3P")) {
      Object obj = map.get("production3P");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProduction3P((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("dqdWeekProductionVolume")) {
      Object obj = map.get("dqdWeekProductionVolume");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDqdWeekProductionVolume((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("kpkWeekProductionVolume")) {
      Object obj = map.get("kpkWeekProductionVolume");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setKpkWeekProductionVolume((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mlWeekProductionVolume")) {
      Object obj = map.get("mlWeekProductionVolume");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMlWeekProductionVolume((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zlcWeekProductionVolume")) {
      Object obj = map.get("zlcWeekProductionVolume");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setZlcWeekProductionVolume((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("beijingProductionPlan")) {
      Object obj = map.get("beijingProductionPlan");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBeijingProductionPlan((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taicangProductionPlan")) {
      Object obj = map.get("taicangProductionPlan");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTaicangProductionPlan((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lastMonthSales")) {
      Object obj = map.get("lastMonthSales");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLastMonthSales((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("openOrder")) {
      Object obj = map.get("openOrder");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOpenOrder((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mtd")) {
      Object obj = map.get("mtd");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMtd((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lockedGoodsCount")) {
      Object obj = map.get("lockedGoodsCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLockedGoodsCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("lockedGoodsOutsideAvailableCount")) {
      Object obj = map.get("lockedGoodsOutsideAvailableCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLockedGoodsOutsideAvailableCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cappingSet")) {
      Object obj = map.get("cappingSet");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCappingSet((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("type")) {
      Object obj = map.get("type");
      if(obj != null) {
        if(obj instanceof String) {
          this.setType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("brand")) {
      Object obj = map.get("brand");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBrand((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("material")) {
      Object obj = map.get("material");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMaterial((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("description")) {
      Object obj = map.get("description");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDescription((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("skuType1")) {
      Object obj = map.get("skuType1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSkuType1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("plant")) {
      Object obj = map.get("plant");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPlant((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("plantDes")) {
      Object obj = map.get("plantDes");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPlantDes((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("warehouseLocation")) {
      Object obj = map.get("warehouseLocation");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWarehouseLocation((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("availableInventoryCount")) {
      Object obj = map.get("availableInventoryCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAvailableInventoryCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("inspectionInventoryCount")) {
      Object obj = map.get("inspectionInventoryCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInspectionInventoryCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("inspectionbatch")) {
      Object obj = map.get("inspectionbatch");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInspectionbatch((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("intransitCount")) {
      Object obj = map.get("intransitCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIntransitCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("intransitDetail")) {
      Object obj = map.get("intransitDetail");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIntransitDetail((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("openDRP")) {
      Object obj = map.get("openDRP");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOpenDRP((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("production3P")) {
      Object obj = map.get("production3P");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProduction3P((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("dqdWeekProductionVolume")) {
      Object obj = map.get("dqdWeekProductionVolume");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDqdWeekProductionVolume((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("kpkWeekProductionVolume")) {
      Object obj = map.get("kpkWeekProductionVolume");
      if(obj != null) {
        if(obj instanceof String) {
          this.setKpkWeekProductionVolume((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("mlWeekProductionVolume")) {
      Object obj = map.get("mlWeekProductionVolume");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMlWeekProductionVolume((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("zlcWeekProductionVolume")) {
      Object obj = map.get("zlcWeekProductionVolume");
      if(obj != null) {
        if(obj instanceof String) {
          this.setZlcWeekProductionVolume((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("beijingProductionPlan")) {
      Object obj = map.get("beijingProductionPlan");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBeijingProductionPlan((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taicangProductionPlan")) {
      Object obj = map.get("taicangProductionPlan");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaicangProductionPlan((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("lastMonthSales")) {
      Object obj = map.get("lastMonthSales");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLastMonthSales((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("openOrder")) {
      Object obj = map.get("openOrder");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOpenOrder((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("mtd")) {
      Object obj = map.get("mtd");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMtd((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("lockedGoodsCount")) {
      Object obj = map.get("lockedGoodsCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLockedGoodsCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("lockedGoodsOutsideAvailableCount")) {
      Object obj = map.get("lockedGoodsOutsideAvailableCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLockedGoodsOutsideAvailableCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cappingSet")) {
      Object obj = map.get("cappingSet");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCappingSet((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
  }
}
