package com.xforceplus.ultraman.app.jcunileverbpi.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-12-24
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SupplierProduct implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 联合利华产品编号
   */
  @TableField("unilverProductCode")
  private String unilverProductCode;

  /**
   * 产品条码
   */
  @TableField("productBarCode")
  private String productBarCode;

  /**
   * 京东产品编号
   */
  @TableField("jdProductCode")
  private String jdProductCode;

  /**
   * 联合利华产品名称
   */
  @TableField("unilverProductName")
  private String unilverProductName;

  /**
   * 包装规格（箱规）
   */
  @TableField("packingSpecification")
  private Long packingSpecification;

  /**
   * 售完即止
   */
  @TableField("isSoldOut")
  private String isSoldOut;

  /**
   * 冬保
   */
  @TableField("isWinterProtection")
  private String isWinterProtection;

  /**
   * 品牌
   */
  private String brand;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 小类
   */
  private String subclass;

  /**
   * 产品标识
   */
  @TableField("productMarking")
  private String productMarking;

  /**
   * SKU应有数
   */
  @TableField("skuNumbers")
  private Long skuNumbers;

  /**
   * 组织树
   */
  private String orgTree;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("unilverProductCode", unilverProductCode);
      map.put("productBarCode", productBarCode);
      map.put("jdProductCode", jdProductCode);
      map.put("unilverProductName", unilverProductName);
      map.put("packingSpecification", packingSpecification);
      map.put("isSoldOut", isSoldOut);
      map.put("isWinterProtection", isWinterProtection);
      map.put("brand", brand);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("subclass", subclass);
      map.put("productMarking", productMarking);
      map.put("skuNumbers", skuNumbers);
      map.put("org_tree", orgTree);

      return map;
  }

  public static SupplierProduct fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    SupplierProduct entity = new SupplierProduct();
    if(map.containsKey("unilverProductCode")) {
      Object obj = map.get("unilverProductCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnilverProductCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productBarCode")) {
      Object obj = map.get("productBarCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductBarCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jdProductCode")) {
      Object obj = map.get("jdProductCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setJdProductCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("unilverProductName")) {
      Object obj = map.get("unilverProductName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUnilverProductName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("packingSpecification")) {
      Object obj = map.get("packingSpecification");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setPackingSpecification((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setPackingSpecification(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setPackingSpecification(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("isSoldOut")) {
      Object obj = map.get("isSoldOut");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsSoldOut((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isWinterProtection")) {
      Object obj = map.get("isWinterProtection");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsWinterProtection((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("brand")) {
      Object obj = map.get("brand");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBrand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("subclass")) {
      Object obj = map.get("subclass");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSubclass((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productMarking")) {
      Object obj = map.get("productMarking");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProductMarking((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("skuNumbers")) {
      Object obj = map.get("skuNumbers");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSkuNumbers((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSkuNumbers(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSkuNumbers(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("unilverProductCode")) {
      Object obj = map.get("unilverProductCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnilverProductCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("productBarCode")) {
      Object obj = map.get("productBarCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProductBarCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("jdProductCode")) {
      Object obj = map.get("jdProductCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setJdProductCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("unilverProductName")) {
      Object obj = map.get("unilverProductName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUnilverProductName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("packingSpecification")) {
      Object obj = map.get("packingSpecification");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setPackingSpecification((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setPackingSpecification(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setPackingSpecification(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("isSoldOut")) {
      Object obj = map.get("isSoldOut");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsSoldOut((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("isWinterProtection")) {
      Object obj = map.get("isWinterProtection");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsWinterProtection((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("brand")) {
      Object obj = map.get("brand");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBrand((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("subclass")) {
      Object obj = map.get("subclass");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSubclass((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("productMarking")) {
      Object obj = map.get("productMarking");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProductMarking((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("skuNumbers")) {
      Object obj = map.get("skuNumbers");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setSkuNumbers((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSkuNumbers(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setSkuNumbers(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
  }
}
