package com.xforceplus.ultraman.app.jcunileverbpi.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-12-24
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SzSupplierGoodsDetail implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 商品名称
   */
  @TableField("goodsName")
  private String goodsName;

  /**
   * SKU
   */
  private String sku;

  /**
   * 品牌
   */
  private String brand;

  /**
   * 一级类目
   */
  @TableField("firstCategory")
  private String firstCategory;

  /**
   * 二级类目
   */
  @TableField("secondCategory")
  private String secondCategory;

  /**
   * 三级类目
   */
  @TableField("thirdCategory")
  private String thirdCategory;

  /**
   * 店铺名称
   */
  @TableField("storeName")
  private String storeName;

  /**
   * 供应商简码
   */
  @TableField("supplierCode")
  private String supplierCode;

  /**
   * 是否售完即止
   */
  @TableField("isSoldOut")
  private String isSoldOut;

  /**
   * 是否厂直
   */
  @TableField("isFactorySales")
  private String isFactorySales;

  /**
   * 全国厂直可用库存
   */
  @TableField("nationalFactorySalesAvailableInventory")
  private String nationalFactorySalesAvailableInventory;

  /**
   * 是否影分身
   */
  @TableField("isClone")
  private String isClone;

  /**
   * 是否虚拟组套
   */
  @TableField("isVirtualGroupSet")
  private String isVirtualGroupSet;

  /**
   * 是否虚拟品类
   */
  @TableField("isVirtualCategory")
  private String isVirtualCategory;

  /**
   * 上下柜状态
   */
  @TableField("upperLowerCabinetsStatus")
  private String upperLowerCabinetsStatus;

  /**
   * 上柜时间
   */
  @TableField("upperLowerCabinetsTime")
  private String upperLowerCabinetsTime;

  /**
   * 是否平行库存
   */
  @TableField("isParallelInventory")
  private String isParallelInventory;

  /**
   * 是否赠品
   */
  @TableField("isGiveaway")
  private String isGiveaway;

  /**
   * SPU编码
   */
  @TableField("spuCode")
  private String spuCode;

  /**
   * 条形码
   */
  @TableField("barCode")
  private String barCode;

  /**
   * 京东价
   */
  @TableField("jdPrice")
  private BigDecimal jdPrice;

  /**
   * 全国采购价
   */
  @TableField("nationalPrice")
  private String nationalPrice;

  /**
   * 仓网类型
   */
  @TableField("networkWarehouseType")
  private String networkWarehouseType;

  /**
   * 保质期
   */
  @TableField("expirationDate")
  private String expirationDate;

  /**
   * 长度
   */
  private String length;

  /**
   * 宽度
   */
  private String width;

  /**
   * 高度
   */
  private String height;

  /**
   * 重量
   */
  private String weight;

  /**
   * 全国7日三级销量band
   */
  @TableField("national7DaySalesBand")
  private String national7DaySalesBand;

  /**
   * 全国28日三级销量band
   */
  @TableField("national28DaySalesBand")
  private String national28DaySalesBand;

  /**
   * RDC
   */
  private String rdc;

  /**
   * 配送中心
   */
  @TableField("distributionCenter")
  private String distributionCenter;

  /**
   * 库存件数
   */
  @TableField("inventoryCount")
  private String inventoryCount;

  /**
   * 现货库存
   */
  @TableField("spotInventoryCount")
  private String spotInventoryCount;

  /**
   * 内配在途库存
   */
  @TableField("inTransitInventoryCount")
  private String inTransitInventoryCount;

  /**
   * 内配入
   */
  @TableField("inAllocation")
  private String inAllocation;

  /**
   * 内配出
   */
  @TableField("ountAllocation")
  private String ountAllocation;

  /**
   * 已锁定
   */
  @TableField("isLocked")
  private String isLocked;

  /**
   * 可用库存
   */
  @TableField("availableInventoryCount")
  private String availableInventoryCount;

  /**
   * 采购未到货
   */
  @TableField("notReceivedPurchase")
  private String notReceivedPurchase;

  /**
   * 可订购库存
   */
  @TableField("canOrderedInventoryCount")
  private String canOrderedInventoryCount;

  /**
   * 订单预定
   */
  @TableField("orderedInventoryCount")
  private String orderedInventoryCount;

  /**
   * VMI库存
   */
  @TableField("vmiInventoryCount")
  private String vmiInventoryCount;

  /**
   * 不可售
   */
  @TableField("notForSale")
  private String notForSale;

  /**
   * 大件7天内待预占数量
   */
  @TableField("largeItems7DayPreCount")
  private String largeItems7DayPreCount;

  /**
   * 大件8-14天待预占数量
   */
  @TableField("largeItems8To14DayPreCount")
  private String largeItems8To14DayPreCount;

  /**
   * 大件15-21天待预占数量
   */
  @TableField("largeItems15To21DayPreCount")
  private String largeItems15To21DayPreCount;

  /**
   * 大件22-28天待预占数量
   */
  @TableField("largeItems22To28DayPreCount")
  private String largeItems22To28DayPreCount;

  /**
   * 大件28天以上待预占数量
   */
  @TableField("largeItems28DaysMorePreCount")
  private String largeItems28DaysMorePreCount;

  /**
   * 昨日出库商品件数
   */
  @TableField("shippedOutYesterdayInventoryCount")
  private String shippedOutYesterdayInventoryCount;

  /**
   * 近7日出库商品件数
   */
  @TableField("shippedOut7DayInventoryCount")
  private String shippedOut7DayInventoryCount;

  /**
   * 近14日出库商品件数
   */
  @TableField("shippedOut14DayInventoryCount")
  private String shippedOut14DayInventoryCount;

  /**
   * 近28日出库商品件数
   */
  @TableField("shippedOut28DayInventoryCount")
  private String shippedOut28DayInventoryCount;

  /**
   * 近30日出库商品件数
   */
  @TableField("shippedOut30DayInventoryCount")
  private String shippedOut30DayInventoryCount;

  /**
   * 近60日出库商品件数
   */
  @TableField("shippedOut60DayInventoryCount")
  private String shippedOut60DayInventoryCount;

  /**
   * 近90日出库商品件数
   */
  @TableField("shippedOut90DayInventoryCount")
  private String shippedOut90DayInventoryCount;

  /**
   * 月至今出库商品件数
   */
  @TableField("shippedOutMonthToNowInventoryCount")
  private String shippedOutMonthToNowInventoryCount;

  /**
   * 昨日收货地商品件数
   */
  @TableField("placeOfReceiptYesterdayInventoryCount")
  private String placeOfReceiptYesterdayInventoryCount;

  /**
   * 近7日收货地商品件数
   */
  @TableField("placeOfReceipt7DayInventoryCount")
  private String placeOfReceipt7DayInventoryCount;

  /**
   * 近14日收货地商品件数
   */
  @TableField("placeOfReceipt14DayInventoryCount")
  private String placeOfReceipt14DayInventoryCount;

  /**
   * 近28日收货地商品件数
   */
  @TableField("placeOfReceipt28DayInventoryCount")
  private String placeOfReceipt28DayInventoryCount;

  /**
   * 近30日收货地商品件数
   */
  @TableField("placeOfReceipt30DayInventoryCount")
  private String placeOfReceipt30DayInventoryCount;

  /**
   * 近60日收货地商品件数
   */
  @TableField("placeOfReceipt60DayInventoryCount")
  private String placeOfReceipt60DayInventoryCount;

  /**
   * 近90日收货地商品件数
   */
  @TableField("placeOfReceipt90DayInventoryCount")
  private String placeOfReceipt90DayInventoryCount;

  /**
   * 月至今收货地商品件数
   */
  @TableField("placeOfReceiptMonthToNowInventoryCount")
  private String placeOfReceiptMonthToNowInventoryCount;

  /**
   * 昨日厂直出库商品件数
   */
  @TableField("factorySalesYesterdayInventoryCount")
  private String factorySalesYesterdayInventoryCount;

  /**
   * 近7日厂直出库商品件数
   */
  @TableField("factorySales7DayInventoryCount")
  private String factorySales7DayInventoryCount;

  /**
   * 近14日厂直出库商品件数
   */
  @TableField("factorySales14DayInventoryCount")
  private String factorySales14DayInventoryCount;

  /**
   * 近28日厂直出库商品件数
   */
  @TableField("factorySales28DayInventoryCount")
  private String factorySales28DayInventoryCount;

  /**
   * 近30日厂直出库商品件数
   */
  @TableField("factorySales30DayInventoryCount")
  private String factorySales30DayInventoryCount;

  /**
   * 近60日厂直出库商品件数
   */
  @TableField("factorySales60DayInventoryCount")
  private String factorySales60DayInventoryCount;

  /**
   * 近90日厂直出库商品件数
   */
  @TableField("factorySales90DayInventoryCount")
  private String factorySales90DayInventoryCount;

  /**
   * 月至今厂直出库商品件数
   */
  @TableField("factorySalesMonthToNowInventoryCount")
  private String factorySalesMonthToNowInventoryCount;

  /**
   * 昨日VMI出库商品件数
   */
  @TableField("vmiYesterdayInventoryCount")
  private String vmiYesterdayInventoryCount;

  /**
   * 近7日VMI出库商品件数
   */
  @TableField("vim7DayInventoryCount")
  private String vim7DayInventoryCount;

  /**
   * 近14日VMI出库商品件数
   */
  @TableField("vim14DayInventoryCount")
  private String vim14DayInventoryCount;

  /**
   * 近28日VMI出库商品件数
   */
  @TableField("vim28DayInventoryCount")
  private String vim28DayInventoryCount;

  /**
   * 近30日VMI出库商品件数
   */
  @TableField("vim30DayInventoryCount")
  private String vim30DayInventoryCount;

  /**
   * 近60日VMI出库商品件数
   */
  @TableField("vim60DayInventoryCount")
  private String vim60DayInventoryCount;

  /**
   * 近90日VMI出库商品件数
   */
  @TableField("vim90DayInventoryCount")
  private String vim90DayInventoryCount;

  /**
   * 月至今VMI出库商品件数
   */
  @TableField("vimMonthToNowInventoryCount")
  private String vimMonthToNowInventoryCount;

  /**
   * 7日有货天数
   */
  @TableField("inStock7Day")
  private String inStock7Day;

  /**
   * 14日有货天数
   */
  @TableField("inStock14Day")
  private String inStock14Day;

  /**
   * 28日有货天数
   */
  @TableField("inStock28Day")
  private String inStock28Day;

  /**
   * 30日有货天数
   */
  @TableField("inStock30Day")
  private String inStock30Day;

  /**
   * 预计可售天数
   */
  @TableField("expectedAvailableForSaleDays")
  private String expectedAvailableForSaleDays;

  /**
   * 无货pv
   */
  @TableField("pvOutSock")
  private String pvOutSock;

  /**
   * 月至今无货pv
   */
  @TableField("pvOutSockMonthToNow")
  private String pvOutSockMonthToNow;

  /**
   * PV现货率
   */
  @TableField("pvInStockRatePv")
  private String pvInStockRatePv;

  /**
   * 月至今pv现货率
   */
  @TableField("pvMonthToNowInStockRate")
  private String pvMonthToNowInStockRate;

  /**
   * 采购未到货-已回告
   */
  @TableField("procurementNotYetReceivedReportedBack")
  private String procurementNotYetReceivedReportedBack;

  /**
   * 采购未到货-已预约
   */
  @TableField("procurementNotYetReceivedAlreadyBooked")
  private String procurementNotYetReceivedAlreadyBooked;

  /**
   * 昨日采购入库件数
   */
  @TableField("procurementYesterdayInStorageCount")
  private String procurementYesterdayInStorageCount;

  /**
   * 近7日采购入库件数
   */
  @TableField("procurement7DayInStorageCount")
  private String procurement7DayInStorageCount;

  /**
   * 近14日采购入库件数
   */
  @TableField("procurement14DayInStorageCount")
  private String procurement14DayInStorageCount;

  /**
   * 近28日采购入库件数
   */
  @TableField("procurement28DayInStorageCount")
  private String procurement28DayInStorageCount;

  /**
   * 近30日采购入库件数
   */
  @TableField("procurement30DayInStorageCount")
  private String procurement30DayInStorageCount;

  /**
   * 月至今采购入库件数
   */
  @TableField("procurementMonthToNowInStorageCount")
  private String procurementMonthToNowInStorageCount;

  /**
   * 昨日采购下单件数
   */
  @TableField("procurementYesterdayPlaceOrderCount")
  private String procurementYesterdayPlaceOrderCount;

  /**
   * 近7日采购下单件数
   */
  @TableField("procurement7DayPlaceOrderCount")
  private String procurement7DayPlaceOrderCount;

  /**
   * 近14日采购下单件数
   */
  @TableField("procurement14DayPlaceOrderCount")
  private String procurement14DayPlaceOrderCount;

  /**
   * 近28日采购下单件数
   */
  @TableField("procurement28DayPlaceOrderCount")
  private String procurement28DayPlaceOrderCount;

  /**
   * 近30日采购下单件数
   */
  @TableField("procurement30DayPlaceOrderCount")
  private String procurement30DayPlaceOrderCount;

  /**
   * 月至今采购下单件数
   */
  @TableField("procurementMonthToNowPlaceOrderCount")
  private String procurementMonthToNowPlaceOrderCount;

  /**
   * 昨日退供应商件数
   */
  @TableField("returnSupplierYesterdayCount")
  private String returnSupplierYesterdayCount;

  /**
   * 近7日退供应商件数
   */
  @TableField("returnSupplier7DayCount")
  private String returnSupplier7DayCount;

  /**
   * 近14日退供应商件数
   */
  @TableField("returnSupplier14DayCount")
  private String returnSupplier14DayCount;

  /**
   * 近28日退供应商件数
   */
  @TableField("returnSupplier28DayCount")
  private String returnSupplier28DayCount;

  /**
   * 近30日退供应商件数
   */
  @TableField("returnSupplier30DayCount")
  private String returnSupplier30DayCount;

  /**
   * 月至今退供应商件数
   */
  @TableField("returnSupplierMonthToNowCount")
  private String returnSupplierMonthToNowCount;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 供应商名称
   */
  @TableField("supplierName")
  private String supplierName;

  /**
   * 时间
   */
  private String time;

  /**
   * 组织树
   */
  private String orgTree;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("goodsName", goodsName);
      map.put("sku", sku);
      map.put("brand", brand);
      map.put("firstCategory", firstCategory);
      map.put("secondCategory", secondCategory);
      map.put("thirdCategory", thirdCategory);
      map.put("storeName", storeName);
      map.put("supplierCode", supplierCode);
      map.put("isSoldOut", isSoldOut);
      map.put("isFactorySales", isFactorySales);
      map.put("nationalFactorySalesAvailableInventory", nationalFactorySalesAvailableInventory);
      map.put("isClone", isClone);
      map.put("isVirtualGroupSet", isVirtualGroupSet);
      map.put("isVirtualCategory", isVirtualCategory);
      map.put("upperLowerCabinetsStatus", upperLowerCabinetsStatus);
      map.put("upperLowerCabinetsTime", upperLowerCabinetsTime);
      map.put("isParallelInventory", isParallelInventory);
      map.put("isGiveaway", isGiveaway);
      map.put("spuCode", spuCode);
      map.put("barCode", barCode);
      map.put("jdPrice", jdPrice);
      map.put("nationalPrice", nationalPrice);
      map.put("networkWarehouseType", networkWarehouseType);
      map.put("expirationDate", expirationDate);
      map.put("length", length);
      map.put("width", width);
      map.put("height", height);
      map.put("weight", weight);
      map.put("national7DaySalesBand", national7DaySalesBand);
      map.put("national28DaySalesBand", national28DaySalesBand);
      map.put("rdc", rdc);
      map.put("distributionCenter", distributionCenter);
      map.put("inventoryCount", inventoryCount);
      map.put("spotInventoryCount", spotInventoryCount);
      map.put("inTransitInventoryCount", inTransitInventoryCount);
      map.put("inAllocation", inAllocation);
      map.put("ountAllocation", ountAllocation);
      map.put("isLocked", isLocked);
      map.put("availableInventoryCount", availableInventoryCount);
      map.put("notReceivedPurchase", notReceivedPurchase);
      map.put("canOrderedInventoryCount", canOrderedInventoryCount);
      map.put("orderedInventoryCount", orderedInventoryCount);
      map.put("vmiInventoryCount", vmiInventoryCount);
      map.put("notForSale", notForSale);
      map.put("largeItems7DayPreCount", largeItems7DayPreCount);
      map.put("largeItems8To14DayPreCount", largeItems8To14DayPreCount);
      map.put("largeItems15To21DayPreCount", largeItems15To21DayPreCount);
      map.put("largeItems22To28DayPreCount", largeItems22To28DayPreCount);
      map.put("largeItems28DaysMorePreCount", largeItems28DaysMorePreCount);
      map.put("shippedOutYesterdayInventoryCount", shippedOutYesterdayInventoryCount);
      map.put("shippedOut7DayInventoryCount", shippedOut7DayInventoryCount);
      map.put("shippedOut14DayInventoryCount", shippedOut14DayInventoryCount);
      map.put("shippedOut28DayInventoryCount", shippedOut28DayInventoryCount);
      map.put("shippedOut30DayInventoryCount", shippedOut30DayInventoryCount);
      map.put("shippedOut60DayInventoryCount", shippedOut60DayInventoryCount);
      map.put("shippedOut90DayInventoryCount", shippedOut90DayInventoryCount);
      map.put("shippedOutMonthToNowInventoryCount", shippedOutMonthToNowInventoryCount);
      map.put("placeOfReceiptYesterdayInventoryCount", placeOfReceiptYesterdayInventoryCount);
      map.put("placeOfReceipt7DayInventoryCount", placeOfReceipt7DayInventoryCount);
      map.put("placeOfReceipt14DayInventoryCount", placeOfReceipt14DayInventoryCount);
      map.put("placeOfReceipt28DayInventoryCount", placeOfReceipt28DayInventoryCount);
      map.put("placeOfReceipt30DayInventoryCount", placeOfReceipt30DayInventoryCount);
      map.put("placeOfReceipt60DayInventoryCount", placeOfReceipt60DayInventoryCount);
      map.put("placeOfReceipt90DayInventoryCount", placeOfReceipt90DayInventoryCount);
      map.put("placeOfReceiptMonthToNowInventoryCount", placeOfReceiptMonthToNowInventoryCount);
      map.put("factorySalesYesterdayInventoryCount", factorySalesYesterdayInventoryCount);
      map.put("factorySales7DayInventoryCount", factorySales7DayInventoryCount);
      map.put("factorySales14DayInventoryCount", factorySales14DayInventoryCount);
      map.put("factorySales28DayInventoryCount", factorySales28DayInventoryCount);
      map.put("factorySales30DayInventoryCount", factorySales30DayInventoryCount);
      map.put("factorySales60DayInventoryCount", factorySales60DayInventoryCount);
      map.put("factorySales90DayInventoryCount", factorySales90DayInventoryCount);
      map.put("factorySalesMonthToNowInventoryCount", factorySalesMonthToNowInventoryCount);
      map.put("vmiYesterdayInventoryCount", vmiYesterdayInventoryCount);
      map.put("vim7DayInventoryCount", vim7DayInventoryCount);
      map.put("vim14DayInventoryCount", vim14DayInventoryCount);
      map.put("vim28DayInventoryCount", vim28DayInventoryCount);
      map.put("vim30DayInventoryCount", vim30DayInventoryCount);
      map.put("vim60DayInventoryCount", vim60DayInventoryCount);
      map.put("vim90DayInventoryCount", vim90DayInventoryCount);
      map.put("vimMonthToNowInventoryCount", vimMonthToNowInventoryCount);
      map.put("inStock7Day", inStock7Day);
      map.put("inStock14Day", inStock14Day);
      map.put("inStock28Day", inStock28Day);
      map.put("inStock30Day", inStock30Day);
      map.put("expectedAvailableForSaleDays", expectedAvailableForSaleDays);
      map.put("pvOutSock", pvOutSock);
      map.put("pvOutSockMonthToNow", pvOutSockMonthToNow);
      map.put("pvInStockRatePv", pvInStockRatePv);
      map.put("pvMonthToNowInStockRate", pvMonthToNowInStockRate);
      map.put("procurementNotYetReceivedReportedBack", procurementNotYetReceivedReportedBack);
      map.put("procurementNotYetReceivedAlreadyBooked", procurementNotYetReceivedAlreadyBooked);
      map.put("procurementYesterdayInStorageCount", procurementYesterdayInStorageCount);
      map.put("procurement7DayInStorageCount", procurement7DayInStorageCount);
      map.put("procurement14DayInStorageCount", procurement14DayInStorageCount);
      map.put("procurement28DayInStorageCount", procurement28DayInStorageCount);
      map.put("procurement30DayInStorageCount", procurement30DayInStorageCount);
      map.put("procurementMonthToNowInStorageCount", procurementMonthToNowInStorageCount);
      map.put("procurementYesterdayPlaceOrderCount", procurementYesterdayPlaceOrderCount);
      map.put("procurement7DayPlaceOrderCount", procurement7DayPlaceOrderCount);
      map.put("procurement14DayPlaceOrderCount", procurement14DayPlaceOrderCount);
      map.put("procurement28DayPlaceOrderCount", procurement28DayPlaceOrderCount);
      map.put("procurement30DayPlaceOrderCount", procurement30DayPlaceOrderCount);
      map.put("procurementMonthToNowPlaceOrderCount", procurementMonthToNowPlaceOrderCount);
      map.put("returnSupplierYesterdayCount", returnSupplierYesterdayCount);
      map.put("returnSupplier7DayCount", returnSupplier7DayCount);
      map.put("returnSupplier14DayCount", returnSupplier14DayCount);
      map.put("returnSupplier28DayCount", returnSupplier28DayCount);
      map.put("returnSupplier30DayCount", returnSupplier30DayCount);
      map.put("returnSupplierMonthToNowCount", returnSupplierMonthToNowCount);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("supplierName", supplierName);
      map.put("time", time);
      map.put("org_tree", orgTree);

      return map;
  }

  public static SzSupplierGoodsDetail fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    SzSupplierGoodsDetail entity = new SzSupplierGoodsDetail();
    if(map.containsKey("goodsName")) {
      Object obj = map.get("goodsName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGoodsName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sku")) {
      Object obj = map.get("sku");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSku((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("brand")) {
      Object obj = map.get("brand");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBrand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("firstCategory")) {
      Object obj = map.get("firstCategory");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFirstCategory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("secondCategory")) {
      Object obj = map.get("secondCategory");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSecondCategory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("thirdCategory")) {
      Object obj = map.get("thirdCategory");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setThirdCategory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeName")) {
      Object obj = map.get("storeName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierCode")) {
      Object obj = map.get("supplierCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSupplierCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isSoldOut")) {
      Object obj = map.get("isSoldOut");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsSoldOut((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isFactorySales")) {
      Object obj = map.get("isFactorySales");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsFactorySales((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("nationalFactorySalesAvailableInventory")) {
      Object obj = map.get("nationalFactorySalesAvailableInventory");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNationalFactorySalesAvailableInventory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isClone")) {
      Object obj = map.get("isClone");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsClone((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isVirtualGroupSet")) {
      Object obj = map.get("isVirtualGroupSet");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsVirtualGroupSet((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isVirtualCategory")) {
      Object obj = map.get("isVirtualCategory");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsVirtualCategory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("upperLowerCabinetsStatus")) {
      Object obj = map.get("upperLowerCabinetsStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpperLowerCabinetsStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("upperLowerCabinetsTime")) {
      Object obj = map.get("upperLowerCabinetsTime");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpperLowerCabinetsTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isParallelInventory")) {
      Object obj = map.get("isParallelInventory");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsParallelInventory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isGiveaway")) {
      Object obj = map.get("isGiveaway");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsGiveaway((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("spuCode")) {
      Object obj = map.get("spuCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSpuCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("barCode")) {
      Object obj = map.get("barCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBarCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("jdPrice")) {
      Object obj = map.get("jdPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setJdPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setJdPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setJdPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setJdPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setJdPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("nationalPrice")) {
      Object obj = map.get("nationalPrice");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNationalPrice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("networkWarehouseType")) {
      Object obj = map.get("networkWarehouseType");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNetworkWarehouseType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("expirationDate")) {
      Object obj = map.get("expirationDate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExpirationDate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("length")) {
      Object obj = map.get("length");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLength((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("width")) {
      Object obj = map.get("width");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWidth((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("height")) {
      Object obj = map.get("height");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setHeight((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("weight")) {
      Object obj = map.get("weight");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWeight((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("national7DaySalesBand")) {
      Object obj = map.get("national7DaySalesBand");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNational7DaySalesBand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("national28DaySalesBand")) {
      Object obj = map.get("national28DaySalesBand");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNational28DaySalesBand((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("rdc")) {
      Object obj = map.get("rdc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRdc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("distributionCenter")) {
      Object obj = map.get("distributionCenter");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDistributionCenter((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("inventoryCount")) {
      Object obj = map.get("inventoryCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInventoryCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("spotInventoryCount")) {
      Object obj = map.get("spotInventoryCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSpotInventoryCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("inTransitInventoryCount")) {
      Object obj = map.get("inTransitInventoryCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInTransitInventoryCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("inAllocation")) {
      Object obj = map.get("inAllocation");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInAllocation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ountAllocation")) {
      Object obj = map.get("ountAllocation");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOuntAllocation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isLocked")) {
      Object obj = map.get("isLocked");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setIsLocked((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("availableInventoryCount")) {
      Object obj = map.get("availableInventoryCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAvailableInventoryCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("notReceivedPurchase")) {
      Object obj = map.get("notReceivedPurchase");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNotReceivedPurchase((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("canOrderedInventoryCount")) {
      Object obj = map.get("canOrderedInventoryCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCanOrderedInventoryCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderedInventoryCount")) {
      Object obj = map.get("orderedInventoryCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderedInventoryCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vmiInventoryCount")) {
      Object obj = map.get("vmiInventoryCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVmiInventoryCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("notForSale")) {
      Object obj = map.get("notForSale");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNotForSale((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("largeItems7DayPreCount")) {
      Object obj = map.get("largeItems7DayPreCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLargeItems7DayPreCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("largeItems8To14DayPreCount")) {
      Object obj = map.get("largeItems8To14DayPreCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLargeItems8To14DayPreCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("largeItems15To21DayPreCount")) {
      Object obj = map.get("largeItems15To21DayPreCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLargeItems15To21DayPreCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("largeItems22To28DayPreCount")) {
      Object obj = map.get("largeItems22To28DayPreCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLargeItems22To28DayPreCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("largeItems28DaysMorePreCount")) {
      Object obj = map.get("largeItems28DaysMorePreCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLargeItems28DaysMorePreCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shippedOutYesterdayInventoryCount")) {
      Object obj = map.get("shippedOutYesterdayInventoryCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShippedOutYesterdayInventoryCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shippedOut7DayInventoryCount")) {
      Object obj = map.get("shippedOut7DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShippedOut7DayInventoryCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shippedOut14DayInventoryCount")) {
      Object obj = map.get("shippedOut14DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShippedOut14DayInventoryCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shippedOut28DayInventoryCount")) {
      Object obj = map.get("shippedOut28DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShippedOut28DayInventoryCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shippedOut30DayInventoryCount")) {
      Object obj = map.get("shippedOut30DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShippedOut30DayInventoryCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shippedOut60DayInventoryCount")) {
      Object obj = map.get("shippedOut60DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShippedOut60DayInventoryCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shippedOut90DayInventoryCount")) {
      Object obj = map.get("shippedOut90DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShippedOut90DayInventoryCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shippedOutMonthToNowInventoryCount")) {
      Object obj = map.get("shippedOutMonthToNowInventoryCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShippedOutMonthToNowInventoryCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("placeOfReceiptYesterdayInventoryCount")) {
      Object obj = map.get("placeOfReceiptYesterdayInventoryCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPlaceOfReceiptYesterdayInventoryCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("placeOfReceipt7DayInventoryCount")) {
      Object obj = map.get("placeOfReceipt7DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPlaceOfReceipt7DayInventoryCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("placeOfReceipt14DayInventoryCount")) {
      Object obj = map.get("placeOfReceipt14DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPlaceOfReceipt14DayInventoryCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("placeOfReceipt28DayInventoryCount")) {
      Object obj = map.get("placeOfReceipt28DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPlaceOfReceipt28DayInventoryCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("placeOfReceipt30DayInventoryCount")) {
      Object obj = map.get("placeOfReceipt30DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPlaceOfReceipt30DayInventoryCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("placeOfReceipt60DayInventoryCount")) {
      Object obj = map.get("placeOfReceipt60DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPlaceOfReceipt60DayInventoryCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("placeOfReceipt90DayInventoryCount")) {
      Object obj = map.get("placeOfReceipt90DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPlaceOfReceipt90DayInventoryCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("placeOfReceiptMonthToNowInventoryCount")) {
      Object obj = map.get("placeOfReceiptMonthToNowInventoryCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPlaceOfReceiptMonthToNowInventoryCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("factorySalesYesterdayInventoryCount")) {
      Object obj = map.get("factorySalesYesterdayInventoryCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFactorySalesYesterdayInventoryCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("factorySales7DayInventoryCount")) {
      Object obj = map.get("factorySales7DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFactorySales7DayInventoryCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("factorySales14DayInventoryCount")) {
      Object obj = map.get("factorySales14DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFactorySales14DayInventoryCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("factorySales28DayInventoryCount")) {
      Object obj = map.get("factorySales28DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFactorySales28DayInventoryCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("factorySales30DayInventoryCount")) {
      Object obj = map.get("factorySales30DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFactorySales30DayInventoryCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("factorySales60DayInventoryCount")) {
      Object obj = map.get("factorySales60DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFactorySales60DayInventoryCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("factorySales90DayInventoryCount")) {
      Object obj = map.get("factorySales90DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFactorySales90DayInventoryCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("factorySalesMonthToNowInventoryCount")) {
      Object obj = map.get("factorySalesMonthToNowInventoryCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFactorySalesMonthToNowInventoryCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vmiYesterdayInventoryCount")) {
      Object obj = map.get("vmiYesterdayInventoryCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVmiYesterdayInventoryCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vim7DayInventoryCount")) {
      Object obj = map.get("vim7DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVim7DayInventoryCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vim14DayInventoryCount")) {
      Object obj = map.get("vim14DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVim14DayInventoryCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vim28DayInventoryCount")) {
      Object obj = map.get("vim28DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVim28DayInventoryCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vim30DayInventoryCount")) {
      Object obj = map.get("vim30DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVim30DayInventoryCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vim60DayInventoryCount")) {
      Object obj = map.get("vim60DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVim60DayInventoryCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vim90DayInventoryCount")) {
      Object obj = map.get("vim90DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVim90DayInventoryCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vimMonthToNowInventoryCount")) {
      Object obj = map.get("vimMonthToNowInventoryCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVimMonthToNowInventoryCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("inStock7Day")) {
      Object obj = map.get("inStock7Day");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInStock7Day((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("inStock14Day")) {
      Object obj = map.get("inStock14Day");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInStock14Day((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("inStock28Day")) {
      Object obj = map.get("inStock28Day");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInStock28Day((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("inStock30Day")) {
      Object obj = map.get("inStock30Day");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInStock30Day((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("expectedAvailableForSaleDays")) {
      Object obj = map.get("expectedAvailableForSaleDays");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setExpectedAvailableForSaleDays((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pvOutSock")) {
      Object obj = map.get("pvOutSock");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPvOutSock((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pvOutSockMonthToNow")) {
      Object obj = map.get("pvOutSockMonthToNow");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPvOutSockMonthToNow((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pvInStockRatePv")) {
      Object obj = map.get("pvInStockRatePv");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPvInStockRatePv((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("pvMonthToNowInStockRate")) {
      Object obj = map.get("pvMonthToNowInStockRate");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPvMonthToNowInStockRate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementNotYetReceivedReportedBack")) {
      Object obj = map.get("procurementNotYetReceivedReportedBack");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurementNotYetReceivedReportedBack((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementNotYetReceivedAlreadyBooked")) {
      Object obj = map.get("procurementNotYetReceivedAlreadyBooked");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurementNotYetReceivedAlreadyBooked((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementYesterdayInStorageCount")) {
      Object obj = map.get("procurementYesterdayInStorageCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurementYesterdayInStorageCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurement7DayInStorageCount")) {
      Object obj = map.get("procurement7DayInStorageCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurement7DayInStorageCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurement14DayInStorageCount")) {
      Object obj = map.get("procurement14DayInStorageCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurement14DayInStorageCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurement28DayInStorageCount")) {
      Object obj = map.get("procurement28DayInStorageCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurement28DayInStorageCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurement30DayInStorageCount")) {
      Object obj = map.get("procurement30DayInStorageCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurement30DayInStorageCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementMonthToNowInStorageCount")) {
      Object obj = map.get("procurementMonthToNowInStorageCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurementMonthToNowInStorageCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementYesterdayPlaceOrderCount")) {
      Object obj = map.get("procurementYesterdayPlaceOrderCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurementYesterdayPlaceOrderCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurement7DayPlaceOrderCount")) {
      Object obj = map.get("procurement7DayPlaceOrderCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurement7DayPlaceOrderCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurement14DayPlaceOrderCount")) {
      Object obj = map.get("procurement14DayPlaceOrderCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurement14DayPlaceOrderCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurement28DayPlaceOrderCount")) {
      Object obj = map.get("procurement28DayPlaceOrderCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurement28DayPlaceOrderCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurement30DayPlaceOrderCount")) {
      Object obj = map.get("procurement30DayPlaceOrderCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurement30DayPlaceOrderCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("procurementMonthToNowPlaceOrderCount")) {
      Object obj = map.get("procurementMonthToNowPlaceOrderCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setProcurementMonthToNowPlaceOrderCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("returnSupplierYesterdayCount")) {
      Object obj = map.get("returnSupplierYesterdayCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReturnSupplierYesterdayCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("returnSupplier7DayCount")) {
      Object obj = map.get("returnSupplier7DayCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReturnSupplier7DayCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("returnSupplier14DayCount")) {
      Object obj = map.get("returnSupplier14DayCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReturnSupplier14DayCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("returnSupplier28DayCount")) {
      Object obj = map.get("returnSupplier28DayCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReturnSupplier28DayCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("returnSupplier30DayCount")) {
      Object obj = map.get("returnSupplier30DayCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReturnSupplier30DayCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("returnSupplierMonthToNowCount")) {
      Object obj = map.get("returnSupplierMonthToNowCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setReturnSupplierMonthToNowCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("supplierName")) {
      Object obj = map.get("supplierName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSupplierName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("time")) {
      Object obj = map.get("time");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTime((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("goodsName")) {
      Object obj = map.get("goodsName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoodsName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sku")) {
      Object obj = map.get("sku");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSku((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("brand")) {
      Object obj = map.get("brand");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBrand((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("firstCategory")) {
      Object obj = map.get("firstCategory");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFirstCategory((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("secondCategory")) {
      Object obj = map.get("secondCategory");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSecondCategory((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("thirdCategory")) {
      Object obj = map.get("thirdCategory");
      if(obj != null) {
        if(obj instanceof String) {
          this.setThirdCategory((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("storeName")) {
      Object obj = map.get("storeName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStoreName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("supplierCode")) {
      Object obj = map.get("supplierCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSupplierCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("isSoldOut")) {
      Object obj = map.get("isSoldOut");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsSoldOut((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("isFactorySales")) {
      Object obj = map.get("isFactorySales");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsFactorySales((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("nationalFactorySalesAvailableInventory")) {
      Object obj = map.get("nationalFactorySalesAvailableInventory");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNationalFactorySalesAvailableInventory((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("isClone")) {
      Object obj = map.get("isClone");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsClone((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("isVirtualGroupSet")) {
      Object obj = map.get("isVirtualGroupSet");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsVirtualGroupSet((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("isVirtualCategory")) {
      Object obj = map.get("isVirtualCategory");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsVirtualCategory((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("upperLowerCabinetsStatus")) {
      Object obj = map.get("upperLowerCabinetsStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpperLowerCabinetsStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("upperLowerCabinetsTime")) {
      Object obj = map.get("upperLowerCabinetsTime");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpperLowerCabinetsTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("isParallelInventory")) {
      Object obj = map.get("isParallelInventory");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsParallelInventory((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("isGiveaway")) {
      Object obj = map.get("isGiveaway");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsGiveaway((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("spuCode")) {
      Object obj = map.get("spuCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSpuCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("barCode")) {
      Object obj = map.get("barCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBarCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("jdPrice")) {
      Object obj = map.get("jdPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setJdPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setJdPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setJdPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setJdPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setJdPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("nationalPrice")) {
      Object obj = map.get("nationalPrice");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNationalPrice((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("networkWarehouseType")) {
      Object obj = map.get("networkWarehouseType");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNetworkWarehouseType((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("expirationDate")) {
      Object obj = map.get("expirationDate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExpirationDate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("length")) {
      Object obj = map.get("length");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLength((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("width")) {
      Object obj = map.get("width");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWidth((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("height")) {
      Object obj = map.get("height");
      if(obj != null) {
        if(obj instanceof String) {
          this.setHeight((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("weight")) {
      Object obj = map.get("weight");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWeight((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("national7DaySalesBand")) {
      Object obj = map.get("national7DaySalesBand");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNational7DaySalesBand((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("national28DaySalesBand")) {
      Object obj = map.get("national28DaySalesBand");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNational28DaySalesBand((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("rdc")) {
      Object obj = map.get("rdc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRdc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("distributionCenter")) {
      Object obj = map.get("distributionCenter");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDistributionCenter((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("inventoryCount")) {
      Object obj = map.get("inventoryCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInventoryCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("spotInventoryCount")) {
      Object obj = map.get("spotInventoryCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSpotInventoryCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("inTransitInventoryCount")) {
      Object obj = map.get("inTransitInventoryCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInTransitInventoryCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("inAllocation")) {
      Object obj = map.get("inAllocation");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInAllocation((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ountAllocation")) {
      Object obj = map.get("ountAllocation");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOuntAllocation((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("isLocked")) {
      Object obj = map.get("isLocked");
      if(obj != null) {
        if(obj instanceof String) {
          this.setIsLocked((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("availableInventoryCount")) {
      Object obj = map.get("availableInventoryCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAvailableInventoryCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("notReceivedPurchase")) {
      Object obj = map.get("notReceivedPurchase");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNotReceivedPurchase((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("canOrderedInventoryCount")) {
      Object obj = map.get("canOrderedInventoryCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCanOrderedInventoryCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orderedInventoryCount")) {
      Object obj = map.get("orderedInventoryCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderedInventoryCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vmiInventoryCount")) {
      Object obj = map.get("vmiInventoryCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVmiInventoryCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("notForSale")) {
      Object obj = map.get("notForSale");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNotForSale((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("largeItems7DayPreCount")) {
      Object obj = map.get("largeItems7DayPreCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLargeItems7DayPreCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("largeItems8To14DayPreCount")) {
      Object obj = map.get("largeItems8To14DayPreCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLargeItems8To14DayPreCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("largeItems15To21DayPreCount")) {
      Object obj = map.get("largeItems15To21DayPreCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLargeItems15To21DayPreCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("largeItems22To28DayPreCount")) {
      Object obj = map.get("largeItems22To28DayPreCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLargeItems22To28DayPreCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("largeItems28DaysMorePreCount")) {
      Object obj = map.get("largeItems28DaysMorePreCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLargeItems28DaysMorePreCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shippedOutYesterdayInventoryCount")) {
      Object obj = map.get("shippedOutYesterdayInventoryCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShippedOutYesterdayInventoryCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shippedOut7DayInventoryCount")) {
      Object obj = map.get("shippedOut7DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShippedOut7DayInventoryCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shippedOut14DayInventoryCount")) {
      Object obj = map.get("shippedOut14DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShippedOut14DayInventoryCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shippedOut28DayInventoryCount")) {
      Object obj = map.get("shippedOut28DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShippedOut28DayInventoryCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shippedOut30DayInventoryCount")) {
      Object obj = map.get("shippedOut30DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShippedOut30DayInventoryCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shippedOut60DayInventoryCount")) {
      Object obj = map.get("shippedOut60DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShippedOut60DayInventoryCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shippedOut90DayInventoryCount")) {
      Object obj = map.get("shippedOut90DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShippedOut90DayInventoryCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shippedOutMonthToNowInventoryCount")) {
      Object obj = map.get("shippedOutMonthToNowInventoryCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShippedOutMonthToNowInventoryCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("placeOfReceiptYesterdayInventoryCount")) {
      Object obj = map.get("placeOfReceiptYesterdayInventoryCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPlaceOfReceiptYesterdayInventoryCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("placeOfReceipt7DayInventoryCount")) {
      Object obj = map.get("placeOfReceipt7DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPlaceOfReceipt7DayInventoryCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("placeOfReceipt14DayInventoryCount")) {
      Object obj = map.get("placeOfReceipt14DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPlaceOfReceipt14DayInventoryCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("placeOfReceipt28DayInventoryCount")) {
      Object obj = map.get("placeOfReceipt28DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPlaceOfReceipt28DayInventoryCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("placeOfReceipt30DayInventoryCount")) {
      Object obj = map.get("placeOfReceipt30DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPlaceOfReceipt30DayInventoryCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("placeOfReceipt60DayInventoryCount")) {
      Object obj = map.get("placeOfReceipt60DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPlaceOfReceipt60DayInventoryCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("placeOfReceipt90DayInventoryCount")) {
      Object obj = map.get("placeOfReceipt90DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPlaceOfReceipt90DayInventoryCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("placeOfReceiptMonthToNowInventoryCount")) {
      Object obj = map.get("placeOfReceiptMonthToNowInventoryCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPlaceOfReceiptMonthToNowInventoryCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("factorySalesYesterdayInventoryCount")) {
      Object obj = map.get("factorySalesYesterdayInventoryCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFactorySalesYesterdayInventoryCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("factorySales7DayInventoryCount")) {
      Object obj = map.get("factorySales7DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFactorySales7DayInventoryCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("factorySales14DayInventoryCount")) {
      Object obj = map.get("factorySales14DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFactorySales14DayInventoryCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("factorySales28DayInventoryCount")) {
      Object obj = map.get("factorySales28DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFactorySales28DayInventoryCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("factorySales30DayInventoryCount")) {
      Object obj = map.get("factorySales30DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFactorySales30DayInventoryCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("factorySales60DayInventoryCount")) {
      Object obj = map.get("factorySales60DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFactorySales60DayInventoryCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("factorySales90DayInventoryCount")) {
      Object obj = map.get("factorySales90DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFactorySales90DayInventoryCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("factorySalesMonthToNowInventoryCount")) {
      Object obj = map.get("factorySalesMonthToNowInventoryCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFactorySalesMonthToNowInventoryCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vmiYesterdayInventoryCount")) {
      Object obj = map.get("vmiYesterdayInventoryCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVmiYesterdayInventoryCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vim7DayInventoryCount")) {
      Object obj = map.get("vim7DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVim7DayInventoryCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vim14DayInventoryCount")) {
      Object obj = map.get("vim14DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVim14DayInventoryCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vim28DayInventoryCount")) {
      Object obj = map.get("vim28DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVim28DayInventoryCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vim30DayInventoryCount")) {
      Object obj = map.get("vim30DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVim30DayInventoryCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vim60DayInventoryCount")) {
      Object obj = map.get("vim60DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVim60DayInventoryCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vim90DayInventoryCount")) {
      Object obj = map.get("vim90DayInventoryCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVim90DayInventoryCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vimMonthToNowInventoryCount")) {
      Object obj = map.get("vimMonthToNowInventoryCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVimMonthToNowInventoryCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("inStock7Day")) {
      Object obj = map.get("inStock7Day");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInStock7Day((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("inStock14Day")) {
      Object obj = map.get("inStock14Day");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInStock14Day((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("inStock28Day")) {
      Object obj = map.get("inStock28Day");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInStock28Day((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("inStock30Day")) {
      Object obj = map.get("inStock30Day");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInStock30Day((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("expectedAvailableForSaleDays")) {
      Object obj = map.get("expectedAvailableForSaleDays");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExpectedAvailableForSaleDays((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pvOutSock")) {
      Object obj = map.get("pvOutSock");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPvOutSock((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pvOutSockMonthToNow")) {
      Object obj = map.get("pvOutSockMonthToNow");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPvOutSockMonthToNow((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pvInStockRatePv")) {
      Object obj = map.get("pvInStockRatePv");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPvInStockRatePv((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("pvMonthToNowInStockRate")) {
      Object obj = map.get("pvMonthToNowInStockRate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPvMonthToNowInStockRate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("procurementNotYetReceivedReportedBack")) {
      Object obj = map.get("procurementNotYetReceivedReportedBack");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProcurementNotYetReceivedReportedBack((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("procurementNotYetReceivedAlreadyBooked")) {
      Object obj = map.get("procurementNotYetReceivedAlreadyBooked");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProcurementNotYetReceivedAlreadyBooked((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("procurementYesterdayInStorageCount")) {
      Object obj = map.get("procurementYesterdayInStorageCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProcurementYesterdayInStorageCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("procurement7DayInStorageCount")) {
      Object obj = map.get("procurement7DayInStorageCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProcurement7DayInStorageCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("procurement14DayInStorageCount")) {
      Object obj = map.get("procurement14DayInStorageCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProcurement14DayInStorageCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("procurement28DayInStorageCount")) {
      Object obj = map.get("procurement28DayInStorageCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProcurement28DayInStorageCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("procurement30DayInStorageCount")) {
      Object obj = map.get("procurement30DayInStorageCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProcurement30DayInStorageCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("procurementMonthToNowInStorageCount")) {
      Object obj = map.get("procurementMonthToNowInStorageCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProcurementMonthToNowInStorageCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("procurementYesterdayPlaceOrderCount")) {
      Object obj = map.get("procurementYesterdayPlaceOrderCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProcurementYesterdayPlaceOrderCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("procurement7DayPlaceOrderCount")) {
      Object obj = map.get("procurement7DayPlaceOrderCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProcurement7DayPlaceOrderCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("procurement14DayPlaceOrderCount")) {
      Object obj = map.get("procurement14DayPlaceOrderCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProcurement14DayPlaceOrderCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("procurement28DayPlaceOrderCount")) {
      Object obj = map.get("procurement28DayPlaceOrderCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProcurement28DayPlaceOrderCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("procurement30DayPlaceOrderCount")) {
      Object obj = map.get("procurement30DayPlaceOrderCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProcurement30DayPlaceOrderCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("procurementMonthToNowPlaceOrderCount")) {
      Object obj = map.get("procurementMonthToNowPlaceOrderCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setProcurementMonthToNowPlaceOrderCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("returnSupplierYesterdayCount")) {
      Object obj = map.get("returnSupplierYesterdayCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReturnSupplierYesterdayCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("returnSupplier7DayCount")) {
      Object obj = map.get("returnSupplier7DayCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReturnSupplier7DayCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("returnSupplier14DayCount")) {
      Object obj = map.get("returnSupplier14DayCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReturnSupplier14DayCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("returnSupplier28DayCount")) {
      Object obj = map.get("returnSupplier28DayCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReturnSupplier28DayCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("returnSupplier30DayCount")) {
      Object obj = map.get("returnSupplier30DayCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReturnSupplier30DayCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("returnSupplierMonthToNowCount")) {
      Object obj = map.get("returnSupplierMonthToNowCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReturnSupplierMonthToNowCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("supplierName")) {
      Object obj = map.get("supplierName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSupplierName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("time")) {
      Object obj = map.get("time");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTime((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
  }
}
