package com.xforceplus.ultraman.app.jcunileverbpi.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import com.xforceplus.ultraman.bocp.gen.obj.MetadataConvertable;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2024-12-24
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class UlOMR implements MetadataConvertable, Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 售达方
   */
  @TableField("soldToCode")
  private String soldToCode;

  /**
   * Ship-to party Name
   */
  @TableField("shipToPartyName")
  private String shipToPartyName;

  /**
   * 销售凭证
   */
  @TableField("documentNo")
  private String documentNo;

  /**
   * 交货
   */
  @TableField("deliveryNumber")
  private String deliveryNumber;

  /**
   * PO Number
   */
  @TableField("poNumber")
  private String poNumber;

  /**
   * 物料
   */
  @TableField("materielNo")
  private String materielNo;

  /**
   * 物料描述
   */
  @TableField("materielDesc")
  private String materielDesc;

  /**
   * 交货数量
   */
  @TableField("deliveryQuantity")
  private String deliveryQuantity;

  /**
   * 累计确认数量
   */
  @TableField("accumulatedQuantity")
  private String accumulatedQuantity;

  /**
   * 订单数量
   */
  @TableField("orderQuantity")
  private String orderQuantity;

  /**
   * Category Description
   */
  @TableField("categoryDescription")
  private String categoryDescription;

  /**
   * Brand Description
   */
  @TableField("brandDescription")
  private String brandDescription;

  /**
   * CCFOT reason
   */
  @TableField("ccfotReason")
  private String ccfotReason;

  /**
   * 工厂
   */
  private String factory;

  /**
   * 净价值
   */
  @TableField("netValue")
  private BigDecimal netValue;

  /**
   * Credit Status
   */
  @TableField("creditStatus")
  private String creditStatus;

  /**
   * Gross Weight
   */
  @TableField("grossWeight")
  private String grossWeight;

  /**
   * 重量单位
   */
  private String weight;

  /**
   * Volume
   */
  private String volume;

  /**
   * Volume Unit
   */
  @TableField("volumeUnit")
  private String volumeUnit;

  /**
   * Ship-to party
   */
  @TableField("shipToParty")
  private String shipToParty;

  /**
   * 开票凭证
   */
  @TableField("invoiceDocument")
  private String invoiceDocument;

  /**
   * 存储位置
   */
  @TableField("storageLocation")
  private String storageLocation;

  /**
   * 已出发票数量
   */
  @TableField("invoiceCount")
  private String invoiceCount;

  /**
   * Initial order quantity
   */
  @TableField("initialOrderQuantity")
  private String initialOrderQuantity;

  /**
   * 销售凭证项目
   */
  @TableField("sellerDocumentProject")
  private String sellerDocumentProject;

  /**
   * List Price Per Sales UOM
   */
  @TableField("listPricePerSalesUOM")
  private String listPricePerSalesUOM;

  /**
   * Mat.Num.Used Customer
   */
  @TableField("matNumUsedCustomer")
  private String matNumUsedCustomer;

  /**
   * Loc.Sal. Regions 1 Name
   */
  @TableField("locSalRegions1Name")
  private String locSalRegions1Name;

  /**
   * Loc.Sal. Regions 2 Name
   */
  @TableField("locSalRegions2Name")
  private String locSalRegions2Name;

  /**
   * Conf quan PAL
   */
  @TableField("confQuanPAL")
  private String confQuanPAL;

  /**
   * 拒绝原因
   */
  @TableField("refuseToReason")
  private String refuseToReason;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * 全部交货状态
   */
  @TableField("allDeliveryStatus")
  private String allDeliveryStatus;

  /**
   * 销售单位
   */
  @TableField("salesUnit")
  private String salesUnit;

  /**
   * Net Price
   */
  @TableField("netPrice")
  private BigDecimal netPrice;

  /**
   * 小计1
   */
  private BigDecimal subtotal1;

  /**
   * 小计6
   */
  private BigDecimal subtotal6;

  /**
   * Order quan PAL
   */
  @TableField("orderQuanPAL")
  private BigDecimal orderQuanPAL;

  /**
   * Net Weight
   */
  @TableField("netWeight")
  private String netWeight;

  /**
   * Initial RDD
   */
  @TableField("initialRDD")
  private String initialRDD;

  /**
   * 凭证日期
   */
  @TableField("documentDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime documentDate;

  /**
   * 实际货物移动日期
   */
  @TableField("actualShipmentDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime actualShipmentDate;

  /**
   * Sch. GI Date Order Item
   */
  @TableField("shcGIDateOrderItem")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime shcGIDateOrderItem;

  /**
   * 开票日期
   */
  @TableField("invoiceDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime invoiceDate;

  /**
   * 请求交货日期
   */
  @TableField("requestDeliveryDate")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime requestDeliveryDate;

  /**
   * 组织树
   */
  private String orgTree;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("soldToCode", soldToCode);
      map.put("shipToPartyName", shipToPartyName);
      map.put("documentNo", documentNo);
      map.put("deliveryNumber", deliveryNumber);
      map.put("poNumber", poNumber);
      map.put("materielNo", materielNo);
      map.put("materielDesc", materielDesc);
      map.put("deliveryQuantity", deliveryQuantity);
      map.put("accumulatedQuantity", accumulatedQuantity);
      map.put("orderQuantity", orderQuantity);
      map.put("categoryDescription", categoryDescription);
      map.put("brandDescription", brandDescription);
      map.put("ccfotReason", ccfotReason);
      map.put("factory", factory);
      map.put("netValue", netValue);
      map.put("creditStatus", creditStatus);
      map.put("grossWeight", grossWeight);
      map.put("weight", weight);
      map.put("volume", volume);
      map.put("volumeUnit", volumeUnit);
      map.put("shipToParty", shipToParty);
      map.put("invoiceDocument", invoiceDocument);
      map.put("storageLocation", storageLocation);
      map.put("invoiceCount", invoiceCount);
      map.put("initialOrderQuantity", initialOrderQuantity);
      map.put("sellerDocumentProject", sellerDocumentProject);
      map.put("listPricePerSalesUOM", listPricePerSalesUOM);
      map.put("matNumUsedCustomer", matNumUsedCustomer);
      map.put("locSalRegions1Name", locSalRegions1Name);
      map.put("locSalRegions2Name", locSalRegions2Name);
      map.put("confQuanPAL", confQuanPAL);
      map.put("refuseToReason", refuseToReason);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("allDeliveryStatus", allDeliveryStatus);
      map.put("salesUnit", salesUnit);
      map.put("netPrice", netPrice);
      map.put("subtotal1", subtotal1);
      map.put("subtotal6", subtotal6);
      map.put("orderQuanPAL", orderQuanPAL);
      map.put("netWeight", netWeight);
      map.put("initialRDD", initialRDD);
      map.put("documentDate", BocpGenUtils.toTimestamp(documentDate));
      map.put("actualShipmentDate", BocpGenUtils.toTimestamp(actualShipmentDate));
      map.put("shcGIDateOrderItem", BocpGenUtils.toTimestamp(shcGIDateOrderItem));
      map.put("invoiceDate", BocpGenUtils.toTimestamp(invoiceDate));
      map.put("requestDeliveryDate", BocpGenUtils.toTimestamp(requestDeliveryDate));
      map.put("org_tree", orgTree);

      return map;
  }

  public static UlOMR fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    UlOMR entity = new UlOMR();
    if(map.containsKey("soldToCode")) {
      Object obj = map.get("soldToCode");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSoldToCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shipToPartyName")) {
      Object obj = map.get("shipToPartyName");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShipToPartyName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentNo")) {
      Object obj = map.get("documentNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDocumentNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deliveryNumber")) {
      Object obj = map.get("deliveryNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeliveryNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("poNumber")) {
      Object obj = map.get("poNumber");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setPoNumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materielNo")) {
      Object obj = map.get("materielNo");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMaterielNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materielDesc")) {
      Object obj = map.get("materielDesc");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMaterielDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("deliveryQuantity")) {
      Object obj = map.get("deliveryQuantity");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeliveryQuantity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("accumulatedQuantity")) {
      Object obj = map.get("accumulatedQuantity");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAccumulatedQuantity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderQuantity")) {
      Object obj = map.get("orderQuantity");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrderQuantity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("categoryDescription")) {
      Object obj = map.get("categoryDescription");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCategoryDescription((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("brandDescription")) {
      Object obj = map.get("brandDescription");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setBrandDescription((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ccfotReason")) {
      Object obj = map.get("ccfotReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCcfotReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("factory")) {
      Object obj = map.get("factory");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setFactory((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("netValue")) {
      Object obj = map.get("netValue");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setNetValue((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setNetValue(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setNetValue(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setNetValue(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setNetValue(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("creditStatus")) {
      Object obj = map.get("creditStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreditStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("grossWeight")) {
      Object obj = map.get("grossWeight");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setGrossWeight((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("weight")) {
      Object obj = map.get("weight");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setWeight((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("volume")) {
      Object obj = map.get("volume");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVolume((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("volumeUnit")) {
      Object obj = map.get("volumeUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setVolumeUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shipToParty")) {
      Object obj = map.get("shipToParty");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setShipToParty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceDocument")) {
      Object obj = map.get("invoiceDocument");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceDocument((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storageLocation")) {
      Object obj = map.get("storageLocation");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setStorageLocation((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceCount")) {
      Object obj = map.get("invoiceCount");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInvoiceCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("initialOrderQuantity")) {
      Object obj = map.get("initialOrderQuantity");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInitialOrderQuantity((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("sellerDocumentProject")) {
      Object obj = map.get("sellerDocumentProject");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSellerDocumentProject((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("listPricePerSalesUOM")) {
      Object obj = map.get("listPricePerSalesUOM");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setListPricePerSalesUOM((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("matNumUsedCustomer")) {
      Object obj = map.get("matNumUsedCustomer");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setMatNumUsedCustomer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("locSalRegions1Name")) {
      Object obj = map.get("locSalRegions1Name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLocSalRegions1Name((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("locSalRegions2Name")) {
      Object obj = map.get("locSalRegions2Name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setLocSalRegions2Name((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("confQuanPAL")) {
      Object obj = map.get("confQuanPAL");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setConfQuanPAL((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refuseToReason")) {
      Object obj = map.get("refuseToReason");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setRefuseToReason((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("allDeliveryStatus")) {
      Object obj = map.get("allDeliveryStatus");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setAllDeliveryStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesUnit")) {
      Object obj = map.get("salesUnit");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setSalesUnit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("netPrice")) {
      Object obj = map.get("netPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setNetPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setNetPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setNetPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setNetPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setNetPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("subtotal1")) {
      Object obj = map.get("subtotal1");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSubtotal1((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSubtotal1(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSubtotal1(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSubtotal1(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSubtotal1(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("subtotal6")) {
      Object obj = map.get("subtotal6");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSubtotal6((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSubtotal6(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSubtotal6(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setSubtotal6(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSubtotal6(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("orderQuanPAL")) {
      Object obj = map.get("orderQuanPAL");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setOrderQuanPAL((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setOrderQuanPAL(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setOrderQuanPAL(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setOrderQuanPAL(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setOrderQuanPAL(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("netWeight")) {
      Object obj = map.get("netWeight");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setNetWeight((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("initialRDD")) {
      Object obj = map.get("initialRDD");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setInitialRDD((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("documentDate")) {
      Object obj = map.get("documentDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setDocumentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setDocumentDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setDocumentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setDocumentDate(null);
      }
    }
    if(map.containsKey("actualShipmentDate")) {
      Object obj = map.get("actualShipmentDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setActualShipmentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setActualShipmentDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setActualShipmentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setActualShipmentDate(null);
      }
    }
    if(map.containsKey("shcGIDateOrderItem")) {
      Object obj = map.get("shcGIDateOrderItem");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setShcGIDateOrderItem(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setShcGIDateOrderItem((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setShcGIDateOrderItem(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setShcGIDateOrderItem(null);
      }
    }
    if(map.containsKey("invoiceDate")) {
      Object obj = map.get("invoiceDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setInvoiceDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setInvoiceDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setInvoiceDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setInvoiceDate(null);
      }
    }
    if(map.containsKey("requestDeliveryDate")) {
      Object obj = map.get("requestDeliveryDate");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setRequestDeliveryDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setRequestDeliveryDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          entity.setRequestDeliveryDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setRequestDeliveryDate(null);
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String && !"$NULL$".equals((String)obj)){
          entity.setOrgTree((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("soldToCode")) {
      Object obj = map.get("soldToCode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSoldToCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shipToPartyName")) {
      Object obj = map.get("shipToPartyName");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShipToPartyName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("documentNo")) {
      Object obj = map.get("documentNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDocumentNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deliveryNumber")) {
      Object obj = map.get("deliveryNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeliveryNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("poNumber")) {
      Object obj = map.get("poNumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPoNumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("materielNo")) {
      Object obj = map.get("materielNo");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMaterielNo((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("materielDesc")) {
      Object obj = map.get("materielDesc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMaterielDesc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("deliveryQuantity")) {
      Object obj = map.get("deliveryQuantity");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeliveryQuantity((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("accumulatedQuantity")) {
      Object obj = map.get("accumulatedQuantity");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAccumulatedQuantity((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("orderQuantity")) {
      Object obj = map.get("orderQuantity");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrderQuantity((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("categoryDescription")) {
      Object obj = map.get("categoryDescription");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCategoryDescription((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("brandDescription")) {
      Object obj = map.get("brandDescription");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBrandDescription((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ccfotReason")) {
      Object obj = map.get("ccfotReason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCcfotReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("factory")) {
      Object obj = map.get("factory");
      if(obj != null) {
        if(obj instanceof String) {
          this.setFactory((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("netValue")) {
      Object obj = map.get("netValue");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setNetValue((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setNetValue(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setNetValue(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setNetValue(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setNetValue(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("creditStatus")) {
      Object obj = map.get("creditStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreditStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("grossWeight")) {
      Object obj = map.get("grossWeight");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGrossWeight((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("weight")) {
      Object obj = map.get("weight");
      if(obj != null) {
        if(obj instanceof String) {
          this.setWeight((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("volume")) {
      Object obj = map.get("volume");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVolume((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("volumeUnit")) {
      Object obj = map.get("volumeUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVolumeUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("shipToParty")) {
      Object obj = map.get("shipToParty");
      if(obj != null) {
        if(obj instanceof String) {
          this.setShipToParty((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceDocument")) {
      Object obj = map.get("invoiceDocument");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceDocument((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("storageLocation")) {
      Object obj = map.get("storageLocation");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStorageLocation((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoiceCount")) {
      Object obj = map.get("invoiceCount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoiceCount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("initialOrderQuantity")) {
      Object obj = map.get("initialOrderQuantity");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInitialOrderQuantity((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("sellerDocumentProject")) {
      Object obj = map.get("sellerDocumentProject");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSellerDocumentProject((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("listPricePerSalesUOM")) {
      Object obj = map.get("listPricePerSalesUOM");
      if(obj != null) {
        if(obj instanceof String) {
          this.setListPricePerSalesUOM((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("matNumUsedCustomer")) {
      Object obj = map.get("matNumUsedCustomer");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMatNumUsedCustomer((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("locSalRegions1Name")) {
      Object obj = map.get("locSalRegions1Name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLocSalRegions1Name((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("locSalRegions2Name")) {
      Object obj = map.get("locSalRegions2Name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLocSalRegions2Name((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("confQuanPAL")) {
      Object obj = map.get("confQuanPAL");
      if(obj != null) {
        if(obj instanceof String) {
          this.setConfQuanPAL((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("refuseToReason")) {
      Object obj = map.get("refuseToReason");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRefuseToReason((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("allDeliveryStatus")) {
      Object obj = map.get("allDeliveryStatus");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAllDeliveryStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesUnit")) {
      Object obj = map.get("salesUnit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesUnit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("netPrice")) {
      Object obj = map.get("netPrice");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setNetPrice((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setNetPrice(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setNetPrice(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setNetPrice(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setNetPrice(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("subtotal1")) {
      Object obj = map.get("subtotal1");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSubtotal1((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSubtotal1(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSubtotal1(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSubtotal1(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSubtotal1(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("subtotal6")) {
      Object obj = map.get("subtotal6");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setSubtotal6((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setSubtotal6(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setSubtotal6(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setSubtotal6(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setSubtotal6(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("orderQuanPAL")) {
      Object obj = map.get("orderQuanPAL");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          this.setOrderQuanPAL((BigDecimal)obj);
        } else if(obj instanceof Long) {
          this.setOrderQuanPAL(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          this.setOrderQuanPAL(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setOrderQuanPAL(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          this.setOrderQuanPAL(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else {
      }
    }
    if(map.containsKey("netWeight")) {
      Object obj = map.get("netWeight");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNetWeight((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("initialRDD")) {
      Object obj = map.get("initialRDD");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInitialRDD((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("documentDate")) {
      Object obj = map.get("documentDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setDocumentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setDocumentDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setDocumentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setDocumentDate(null);
      }
    }
    if(map.containsKey("actualShipmentDate")) {
      Object obj = map.get("actualShipmentDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setActualShipmentDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setActualShipmentDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setActualShipmentDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setActualShipmentDate(null);
      }
    }
    if(map.containsKey("shcGIDateOrderItem")) {
      Object obj = map.get("shcGIDateOrderItem");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setShcGIDateOrderItem(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setShcGIDateOrderItem((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setShcGIDateOrderItem(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setShcGIDateOrderItem(null);
      }
    }
    if(map.containsKey("invoiceDate")) {
      Object obj = map.get("invoiceDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setInvoiceDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setInvoiceDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setInvoiceDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setInvoiceDate(null);
      }
    }
    if(map.containsKey("requestDeliveryDate")) {
      Object obj = map.get("requestDeliveryDate");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setRequestDeliveryDate(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setRequestDeliveryDate((LocalDateTime)obj);
        } else if(obj instanceof String && !"$NULL$".equals((String)obj)) {
          this.setRequestDeliveryDate(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setRequestDeliveryDate(null);
      }
    }
    if(map.containsKey("org_tree")) {
      Object obj = map.get("org_tree");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOrgTree((String)obj);
        }
      } else {
      }
    }
  }
}
