package com.xforceplus.ultraman.app.jcunileverbpi.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcunileverbpi.entity.PastYearOrderDetail;
import com.xforceplus.ultraman.app.jcunileverbpi.service.IPastYearOrderDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-12-24
 */
@RestController
public class PastYearOrderDetailController {

  @Autowired
  private IPastYearOrderDetailService pastYearOrderDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param pastYearOrderDetail ${table.comment}
   * @return
   */
  @GetMapping("/pastyearorderdetails" )
  public XfR getPastYearOrderDetails(XfPage page, PastYearOrderDetail pastYearOrderDetail) {
    return XfR.ok(pastYearOrderDetailServiceImpl.page(page, Wrappers.query(pastYearOrderDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/pastyearorderdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(pastYearOrderDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param pastYearOrderDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/pastyearorderdetails")
  public XfR save(@RequestBody PastYearOrderDetail pastYearOrderDetail) {
     return XfR.ok(pastYearOrderDetailServiceImpl.save(pastYearOrderDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param pastYearOrderDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/pastyearorderdetails/{id}")
  public XfR putUpdate(@RequestBody PastYearOrderDetail pastYearOrderDetail,@PathVariable Long id) {
      pastYearOrderDetail.setId(id);
      return XfR.ok(pastYearOrderDetailServiceImpl.updateById(pastYearOrderDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param pastYearOrderDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/pastyearorderdetails/{id}")
  public XfR patchUpdate(@RequestBody PastYearOrderDetail pastYearOrderDetail,@PathVariable Long id) {
      PastYearOrderDetail uppastYearOrderDetail = pastYearOrderDetailServiceImpl.getById(id);
      if(uppastYearOrderDetail != null){
        uppastYearOrderDetail = ObjectCopyUtils.copyProperties(pastYearOrderDetail,uppastYearOrderDetail,true);
      }
      return XfR.ok(pastYearOrderDetailServiceImpl.updateById(uppastYearOrderDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/pastyearorderdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(pastYearOrderDetailServiceImpl.removeById(id));
  }

  @PostMapping("/pastyearorderdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "past_year_order_detail");
     params.put("request", condition);

     return XfR.ok(pastYearOrderDetailServiceImpl.querys(params));
  }

}
