package com.xforceplus.ultraman.app.jcunileverbpi.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcunileverbpi.entity.JdMakeOrderBookingDetail;
import com.xforceplus.ultraman.app.jcunileverbpi.service.IJdMakeOrderBookingDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-10-21
 */
@RestController
public class JdMakeOrderBookingDetailController {

  @Autowired
  private IJdMakeOrderBookingDetailService jdMakeOrderBookingDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param jdMakeOrderBookingDetail ${table.comment}
   * @return
   */
  @GetMapping("/jdmakeorderbookingdetails" )
  public XfR getJdMakeOrderBookingDetails(XfPage page, JdMakeOrderBookingDetail jdMakeOrderBookingDetail) {
    return XfR.ok(jdMakeOrderBookingDetailServiceImpl.page(page, Wrappers.query(jdMakeOrderBookingDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/jdmakeorderbookingdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(jdMakeOrderBookingDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param jdMakeOrderBookingDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/jdmakeorderbookingdetails")
  public XfR save(@RequestBody JdMakeOrderBookingDetail jdMakeOrderBookingDetail) {
     return XfR.ok(jdMakeOrderBookingDetailServiceImpl.save(jdMakeOrderBookingDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param jdMakeOrderBookingDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/jdmakeorderbookingdetails/{id}")
  public XfR putUpdate(@RequestBody JdMakeOrderBookingDetail jdMakeOrderBookingDetail,@PathVariable Long id) {
      jdMakeOrderBookingDetail.setId(id);
      return XfR.ok(jdMakeOrderBookingDetailServiceImpl.updateById(jdMakeOrderBookingDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param jdMakeOrderBookingDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/jdmakeorderbookingdetails/{id}")
  public XfR patchUpdate(@RequestBody JdMakeOrderBookingDetail jdMakeOrderBookingDetail,@PathVariable Long id) {
      JdMakeOrderBookingDetail upjdMakeOrderBookingDetail = jdMakeOrderBookingDetailServiceImpl.getById(id);
      if(upjdMakeOrderBookingDetail != null){
        upjdMakeOrderBookingDetail = ObjectCopyUtils.copyProperties(jdMakeOrderBookingDetail,upjdMakeOrderBookingDetail,true);
      }
      return XfR.ok(jdMakeOrderBookingDetailServiceImpl.updateById(upjdMakeOrderBookingDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/jdmakeorderbookingdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(jdMakeOrderBookingDetailServiceImpl.removeById(id));
  }

  @PostMapping("/jdmakeorderbookingdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "jd_make_order_booking_detail");
     params.put("request", condition);

     return XfR.ok(jdMakeOrderBookingDetailServiceImpl.querys(params));
  }

}
