package com.xforceplus.ultraman.app.jcunileverbpi.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcunileverbpi.entity.MonthlyGoal;
import com.xforceplus.ultraman.app.jcunileverbpi.service.IMonthlyGoalService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-10-21
 */
@RestController
public class MonthlyGoalController {

  @Autowired
  private IMonthlyGoalService monthlyGoalServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param monthlyGoal ${table.comment}
   * @return
   */
  @GetMapping("/monthlygoals" )
  public XfR getMonthlyGoals(XfPage page, MonthlyGoal monthlyGoal) {
    return XfR.ok(monthlyGoalServiceImpl.page(page, Wrappers.query(monthlyGoal)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/monthlygoals/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(monthlyGoalServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param monthlyGoal ${table.comment}
   * @return XfR
   */
  @PostMapping("/monthlygoals")
  public XfR save(@RequestBody MonthlyGoal monthlyGoal) {
     return XfR.ok(monthlyGoalServiceImpl.save(monthlyGoal));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param monthlyGoal ${table.comment}
   * @return XfR
   */
  @PutMapping("/monthlygoals/{id}")
  public XfR putUpdate(@RequestBody MonthlyGoal monthlyGoal,@PathVariable Long id) {
      monthlyGoal.setId(id);
      return XfR.ok(monthlyGoalServiceImpl.updateById(monthlyGoal));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param monthlyGoal ${table.comment}
   * @return XfR
   */
  @PatchMapping("/monthlygoals/{id}")
  public XfR patchUpdate(@RequestBody MonthlyGoal monthlyGoal,@PathVariable Long id) {
      MonthlyGoal upmonthlyGoal = monthlyGoalServiceImpl.getById(id);
      if(upmonthlyGoal != null){
        upmonthlyGoal = ObjectCopyUtils.copyProperties(monthlyGoal,upmonthlyGoal,true);
      }
      return XfR.ok(monthlyGoalServiceImpl.updateById(upmonthlyGoal));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/monthlygoals/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(monthlyGoalServiceImpl.removeById(id));
  }

  @PostMapping("/monthlygoals/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "monthly_goal");
     params.put("request", condition);

     return XfR.ok(monthlyGoalServiceImpl.querys(params));
  }

}
