package com.xforceplus.ultraman.app.jcunileverbpi.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcunileverbpi.entity.OkMonthlyQuota;
import com.xforceplus.ultraman.app.jcunileverbpi.service.IOkMonthlyQuotaService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-10-21
 */
@RestController
public class OkMonthlyQuotaController {

  @Autowired
  private IOkMonthlyQuotaService okMonthlyQuotaServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param okMonthlyQuota ${table.comment}
   * @return
   */
  @GetMapping("/okmonthlyquotas" )
  public XfR getOkMonthlyQuotas(XfPage page, OkMonthlyQuota okMonthlyQuota) {
    return XfR.ok(okMonthlyQuotaServiceImpl.page(page, Wrappers.query(okMonthlyQuota)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/okmonthlyquotas/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(okMonthlyQuotaServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param okMonthlyQuota ${table.comment}
   * @return XfR
   */
  @PostMapping("/okmonthlyquotas")
  public XfR save(@RequestBody OkMonthlyQuota okMonthlyQuota) {
     return XfR.ok(okMonthlyQuotaServiceImpl.save(okMonthlyQuota));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param okMonthlyQuota ${table.comment}
   * @return XfR
   */
  @PutMapping("/okmonthlyquotas/{id}")
  public XfR putUpdate(@RequestBody OkMonthlyQuota okMonthlyQuota,@PathVariable Long id) {
      okMonthlyQuota.setId(id);
      return XfR.ok(okMonthlyQuotaServiceImpl.updateById(okMonthlyQuota));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param okMonthlyQuota ${table.comment}
   * @return XfR
   */
  @PatchMapping("/okmonthlyquotas/{id}")
  public XfR patchUpdate(@RequestBody OkMonthlyQuota okMonthlyQuota,@PathVariable Long id) {
      OkMonthlyQuota upokMonthlyQuota = okMonthlyQuotaServiceImpl.getById(id);
      if(upokMonthlyQuota != null){
        upokMonthlyQuota = ObjectCopyUtils.copyProperties(okMonthlyQuota,upokMonthlyQuota,true);
      }
      return XfR.ok(okMonthlyQuotaServiceImpl.updateById(upokMonthlyQuota));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/okmonthlyquotas/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(okMonthlyQuotaServiceImpl.removeById(id));
  }

  @PostMapping("/okmonthlyquotas/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "ok_monthly_quota");
     params.put("request", condition);

     return XfR.ok(okMonthlyQuotaServiceImpl.querys(params));
  }

}
