package com.xforceplus.ultraman.app.jcunileverbpi.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcunileverbpi.entity.SmipIce;
import com.xforceplus.ultraman.app.jcunileverbpi.service.ISmipIceService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-10-21
 */
@RestController
public class SmipIceController {

  @Autowired
  private ISmipIceService smipIceServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param smipIce ${table.comment}
   * @return
   */
  @GetMapping("/smipices" )
  public XfR getSmipIces(XfPage page, SmipIce smipIce) {
    return XfR.ok(smipIceServiceImpl.page(page, Wrappers.query(smipIce)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/smipices/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(smipIceServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param smipIce ${table.comment}
   * @return XfR
   */
  @PostMapping("/smipices")
  public XfR save(@RequestBody SmipIce smipIce) {
     return XfR.ok(smipIceServiceImpl.save(smipIce));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param smipIce ${table.comment}
   * @return XfR
   */
  @PutMapping("/smipices/{id}")
  public XfR putUpdate(@RequestBody SmipIce smipIce,@PathVariable Long id) {
      smipIce.setId(id);
      return XfR.ok(smipIceServiceImpl.updateById(smipIce));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param smipIce ${table.comment}
   * @return XfR
   */
  @PatchMapping("/smipices/{id}")
  public XfR patchUpdate(@RequestBody SmipIce smipIce,@PathVariable Long id) {
      SmipIce upsmipIce = smipIceServiceImpl.getById(id);
      if(upsmipIce != null){
        upsmipIce = ObjectCopyUtils.copyProperties(smipIce,upsmipIce,true);
      }
      return XfR.ok(smipIceServiceImpl.updateById(upsmipIce));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/smipices/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(smipIceServiceImpl.removeById(id));
  }

  @PostMapping("/smipices/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "smip_ice");
     params.put("request", condition);

     return XfR.ok(smipIceServiceImpl.querys(params));
  }

}
