package com.xforceplus.ultraman.app.jcunileverbpi.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcunileverbpi.entity.SupplierProduct;
import com.xforceplus.ultraman.app.jcunileverbpi.service.ISupplierProductService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-10-21
 */
@RestController
public class SupplierProductController {

  @Autowired
  private ISupplierProductService supplierProductServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param supplierProduct ${table.comment}
   * @return
   */
  @GetMapping("/supplierproducts" )
  public XfR getSupplierProducts(XfPage page, SupplierProduct supplierProduct) {
    return XfR.ok(supplierProductServiceImpl.page(page, Wrappers.query(supplierProduct)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/supplierproducts/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(supplierProductServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param supplierProduct ${table.comment}
   * @return XfR
   */
  @PostMapping("/supplierproducts")
  public XfR save(@RequestBody SupplierProduct supplierProduct) {
     return XfR.ok(supplierProductServiceImpl.save(supplierProduct));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param supplierProduct ${table.comment}
   * @return XfR
   */
  @PutMapping("/supplierproducts/{id}")
  public XfR putUpdate(@RequestBody SupplierProduct supplierProduct,@PathVariable Long id) {
      supplierProduct.setId(id);
      return XfR.ok(supplierProductServiceImpl.updateById(supplierProduct));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param supplierProduct ${table.comment}
   * @return XfR
   */
  @PatchMapping("/supplierproducts/{id}")
  public XfR patchUpdate(@RequestBody SupplierProduct supplierProduct,@PathVariable Long id) {
      SupplierProduct upsupplierProduct = supplierProductServiceImpl.getById(id);
      if(upsupplierProduct != null){
        upsupplierProduct = ObjectCopyUtils.copyProperties(supplierProduct,upsupplierProduct,true);
      }
      return XfR.ok(supplierProductServiceImpl.updateById(upsupplierProduct));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/supplierproducts/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(supplierProductServiceImpl.removeById(id));
  }

  @PostMapping("/supplierproducts/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "supplier_product");
     params.put("request", condition);

     return XfR.ok(supplierProductServiceImpl.querys(params));
  }

}
