package com.xforceplus.ultraman.app.jcunileverbpi.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcunileverbpi.entity.SzSupplierGoodsDetail;
import com.xforceplus.ultraman.app.jcunileverbpi.service.ISzSupplierGoodsDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-10-21
 */
@RestController
public class SzSupplierGoodsDetailController {

  @Autowired
  private ISzSupplierGoodsDetailService szSupplierGoodsDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param szSupplierGoodsDetail ${table.comment}
   * @return
   */
  @GetMapping("/szsuppliergoodsdetails" )
  public XfR getSzSupplierGoodsDetails(XfPage page, SzSupplierGoodsDetail szSupplierGoodsDetail) {
    return XfR.ok(szSupplierGoodsDetailServiceImpl.page(page, Wrappers.query(szSupplierGoodsDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/szsuppliergoodsdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(szSupplierGoodsDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param szSupplierGoodsDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/szsuppliergoodsdetails")
  public XfR save(@RequestBody SzSupplierGoodsDetail szSupplierGoodsDetail) {
     return XfR.ok(szSupplierGoodsDetailServiceImpl.save(szSupplierGoodsDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param szSupplierGoodsDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/szsuppliergoodsdetails/{id}")
  public XfR putUpdate(@RequestBody SzSupplierGoodsDetail szSupplierGoodsDetail,@PathVariable Long id) {
      szSupplierGoodsDetail.setId(id);
      return XfR.ok(szSupplierGoodsDetailServiceImpl.updateById(szSupplierGoodsDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param szSupplierGoodsDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/szsuppliergoodsdetails/{id}")
  public XfR patchUpdate(@RequestBody SzSupplierGoodsDetail szSupplierGoodsDetail,@PathVariable Long id) {
      SzSupplierGoodsDetail upszSupplierGoodsDetail = szSupplierGoodsDetailServiceImpl.getById(id);
      if(upszSupplierGoodsDetail != null){
        upszSupplierGoodsDetail = ObjectCopyUtils.copyProperties(szSupplierGoodsDetail,upszSupplierGoodsDetail,true);
      }
      return XfR.ok(szSupplierGoodsDetailServiceImpl.updateById(upszSupplierGoodsDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/szsuppliergoodsdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(szSupplierGoodsDetailServiceImpl.removeById(id));
  }

  @PostMapping("/szsuppliergoodsdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "sz_supplier_goods_detail");
     params.put("request", condition);

     return XfR.ok(szSupplierGoodsDetailServiceImpl.querys(params));
  }

}
