package com.xforceplus.ultraman.app.jcunileverbpi.controller;


import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.xforceplus.ultraman.bocp.gen.plugins.XfPage;
import org.springframework.web.bind.annotation.*;
import org.springframework.beans.factory.annotation.Autowired;
import com.xforceplus.ultraman.bocp.gen.api.XfR;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcunileverbpi.entity.VcOrderDetail;
import com.xforceplus.ultraman.app.jcunileverbpi.service.IVcOrderDetailService;
import lombok.AllArgsConstructor;
import com.xforceplus.ultraman.bocp.gen.util.ObjectCopyUtils;
import com.xforceplus.ultraman.bocp.gen.sql.pojo.ConditionQueryRequest;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Controller;

/**
 * ${table.comment}前端控制器
 *
 * @author ultraman
 * @date 2024-10-21
 */
@RestController
public class VcOrderDetailController {

  @Autowired
  private IVcOrderDetailService vcOrderDetailServiceImpl;


  /**
   * 查询所有-分页模式
   * @param page 分页对象
   * @param vcOrderDetail ${table.comment}
   * @return
   */
  @GetMapping("/vcorderdetails" )
  public XfR getVcOrderDetails(XfPage page, VcOrderDetail vcOrderDetail) {
    return XfR.ok(vcOrderDetailServiceImpl.page(page, Wrappers.query(vcOrderDetail)));
  }

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return XfR
   */
  @GetMapping("/vcorderdetails/{id}")
  public XfR getById(@PathVariable Long id) {
     return XfR.ok(vcOrderDetailServiceImpl.getById(id));
  }

  /**
   * 新增${table.comment}
   * @param vcOrderDetail ${table.comment}
   * @return XfR
   */
  @PostMapping("/vcorderdetails")
  public XfR save(@RequestBody VcOrderDetail vcOrderDetail) {
     return XfR.ok(vcOrderDetailServiceImpl.save(vcOrderDetail));
  }

  /**
   * 修改-传入修改后的全部数据${table.comment}
   * @param vcOrderDetail ${table.comment}
   * @return XfR
   */
  @PutMapping("/vcorderdetails/{id}")
  public XfR putUpdate(@RequestBody VcOrderDetail vcOrderDetail,@PathVariable Long id) {
      vcOrderDetail.setId(id);
      return XfR.ok(vcOrderDetailServiceImpl.updateById(vcOrderDetail));
  }

  /**
   * 修改-传入修改的数据${table.comment}
   * @param vcOrderDetail ${table.comment}
   * @return XfR
   */
  @PatchMapping("/vcorderdetails/{id}")
  public XfR patchUpdate(@RequestBody VcOrderDetail vcOrderDetail,@PathVariable Long id) {
      VcOrderDetail upvcOrderDetail = vcOrderDetailServiceImpl.getById(id);
      if(upvcOrderDetail != null){
        upvcOrderDetail = ObjectCopyUtils.copyProperties(vcOrderDetail,upvcOrderDetail,true);
      }
      return XfR.ok(vcOrderDetailServiceImpl.updateById(upvcOrderDetail));
  }

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return XfR
   */
  @DeleteMapping("/vcorderdetails/{id}")
  public XfR removeById(@PathVariable Long id) {
     return XfR.ok(vcOrderDetailServiceImpl.removeById(id));
  }

  @PostMapping("/vcorderdetails/query")
  public XfR querys(@RequestBody ConditionQueryRequest condition) {
     Map<String, Object> params = new HashMap();
     params.put("tableName", "vc_order_detail");
     params.put("request", condition);

     return XfR.ok(vcOrderDetailServiceImpl.querys(params));
  }

}
