package com.xforceplus.ultraman.app.jcunilever.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2023-06-07
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcunilever.entity.OpenARHead;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-unilever")
public interface OpenARHeadFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/openARHead/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param openARHead ${table.comment}
   * @return R
   */
  @PostMapping("/openARHead/add")
  public R save(@RequestBody OpenARHead openARHead);

  /**
   * 修改${table.comment}
   * @param openARHead ${table.comment}
   * @return R
   */
  @PostMapping("/openARHead/update")
  public R updateById(@RequestBody OpenARHead openARHead);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/openARHead/del/{id}" )
  public R removeById(@PathVariable Long id);

}