package com.xforceplus.ultraman.app.jcunilever.controller;


/**
 * OTC业务feign客户端
 *
 * @author ultraman
 * @date 2023-11-29
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcunilever.entity.BillingDetails;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-unilever")
public interface BillingDetailsFeignApi {

  /**
   * 通过id查询OTC业务
   * @param  id
   * @return R
   */
  @GetMapping("/billingDetails/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增OTC业务
   * @param billingDetails OTC业务
   * @return R
   */
  @PostMapping("/billingDetails/add")
  public R save(@RequestBody BillingDetails billingDetails);

  /**
   * 修改OTC业务
   * @param billingDetails OTC业务
   * @return R
   */
  @PostMapping("/billingDetails/update")
  public R updateById(@RequestBody BillingDetails billingDetails);

  /**
   * 通过id删除OTC业务
   * @param  id
   * @return R
   */
  @DeleteMapping("/billingDetails/del/{id}" )
  public R removeById(@PathVariable Long id);

}