package com.xforceplus.ultraman.app.jcunilever.controller;


/**
 * ${table.comment}feign客户端
 *
 * @author ultraman
 * @date 2024-03-13
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcunilever.entity.EmailConfig;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-unilever")
public interface EmailConfigFeignApi {

  /**
   * 通过id查询${table.comment}
   * @param  id
   * @return R
   */
  @GetMapping("/emailConfig/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增${table.comment}
   * @param emailConfig ${table.comment}
   * @return R
   */
  @PostMapping("/emailConfig/add")
  public R save(@RequestBody EmailConfig emailConfig);

  /**
   * 修改${table.comment}
   * @param emailConfig ${table.comment}
   * @return R
   */
  @PostMapping("/emailConfig/update")
  public R updateById(@RequestBody EmailConfig emailConfig);

  /**
   * 通过id删除${table.comment}
   * @param  id
   * @return R
   */
  @DeleteMapping("/emailConfig/del/{id}" )
  public R removeById(@PathVariable Long id);

}