package com.xforceplus.ultraman.app.jcunilever.controller;


/**
 * OTC业务feign客户端
 *
 * @author ultraman
 * @date 2024-03-13
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcunilever.entity.InvoiceMain;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-unilever")
public interface InvoiceMainFeignApi {

  /**
   * 通过id查询OTC业务
   * @param  id
   * @return R
   */
  @GetMapping("/invoiceMain/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增OTC业务
   * @param invoiceMain OTC业务
   * @return R
   */
  @PostMapping("/invoiceMain/add")
  public R save(@RequestBody InvoiceMain invoiceMain);

  /**
   * 修改OTC业务
   * @param invoiceMain OTC业务
   * @return R
   */
  @PostMapping("/invoiceMain/update")
  public R updateById(@RequestBody InvoiceMain invoiceMain);

  /**
   * 通过id删除OTC业务
   * @param  id
   * @return R
   */
  @DeleteMapping("/invoiceMain/del/{id}" )
  public R removeById(@PathVariable Long id);

}