package com.xforceplus.ultraman.app.jcunilever.controller;


/**
 * DTC业务feign客户端
 *
 * @author ultraman
 * @date 2024-03-13
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcunilever.entity.OrderPoolRaw;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-unilever")
public interface OrderPoolRawFeignApi {

  /**
   * 通过id查询DTC业务
   * @param  id
   * @return R
   */
  @GetMapping("/orderPoolRaw/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增DTC业务
   * @param orderPoolRaw DTC业务
   * @return R
   */
  @PostMapping("/orderPoolRaw/add")
  public R save(@RequestBody OrderPoolRaw orderPoolRaw);

  /**
   * 修改DTC业务
   * @param orderPoolRaw DTC业务
   * @return R
   */
  @PostMapping("/orderPoolRaw/update")
  public R updateById(@RequestBody OrderPoolRaw orderPoolRaw);

  /**
   * 通过id删除DTC业务
   * @param  id
   * @return R
   */
  @DeleteMapping("/orderPoolRaw/del/{id}" )
  public R removeById(@PathVariable Long id);

}