package com.xforceplus.ultraman.app.jcunilever.controller;


/**
 * DTC业务feign客户端
 *
 * @author ultraman
 * @date 2024-03-13
 */
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.GetMapping;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.web.bind.annotation.*;
import com.baomidou.mybatisplus.extension.api.R;
import org.apache.commons.lang3.StringUtils;
import com.xforceplus.ultraman.app.jcunilever.entity.SettlementPool;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Controller;
import java.util.List;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;


@FeignClient(name = "jc-unilever")
public interface SettlementPoolFeignApi {

  /**
   * 通过id查询DTC业务
   * @param  id
   * @return R
   */
  @GetMapping("/settlementPool/get/{id}" )
  public R getById(@PathVariable Long id);

  /**
   * 新增DTC业务
   * @param settlementPool DTC业务
   * @return R
   */
  @PostMapping("/settlementPool/add")
  public R save(@RequestBody SettlementPool settlementPool);

  /**
   * 修改DTC业务
   * @param settlementPool DTC业务
   * @return R
   */
  @PostMapping("/settlementPool/update")
  public R updateById(@RequestBody SettlementPool settlementPool);

  /**
   * 通过id删除DTC业务
   * @param  id
   * @return R
   */
  @DeleteMapping("/settlementPool/del/{id}" )
  public R removeById(@PathVariable Long id);

}