package com.xforceplus.ultraman.app.jcunilever.entity;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 订单已提交
 * </p>
 *
 * @author ultraman
 * @since 2022-06-10
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class OrderMainSubmit implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * 申请单号
   */
  @TableField("applyNo")
  private String applyNo;

  /**
   * 店铺Id
   */
  @TableField("storeId")
  private String storeId;

  /**
   * 店铺名称
   */
  @TableField("storeName")
  private String storeName;

  /**
   * 主订单号
   */
  @TableField("mainOrderNo")
  private String mainOrderNo;

  /**
   * 业务类型
   */
  @TableField("businessType")
  private String businessType;

  /**
   * 订单类型
   */
  @TableField("orderType")
  private String orderType;

  /**
   * 购方抬头
   */
  @TableField("purchaserName")
  private String purchaserName;

  /**
   * 购方税号
   */
  @TableField("purchaserTaxNo")
  private String purchaserTaxNo;

  /**
   * 购方地址
   */
  @TableField("purchaserAddress")
  private String purchaserAddress;

  /**
   * 购方电话
   */
  @TableField("purchaserTel")
  private String purchaserTel;

  /**
   * 购方银行名称
   */
  @TableField("purchaserBankName")
  private String purchaserBankName;

  /**
   * 购方银行账号
   */
  @TableField("purchaserBankAccount")
  private String purchaserBankAccount;

  /**
   * 申请类型
   */
  @TableField("applyType")
  private String applyType;

  /**
   * 申请时间
   */
  @TableField("applyTime")
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime applyTime;

  /**
   * 结算状态
   */
  @TableField("settlementStatus")
  private String settlementStatus;

  /**
   * 开票状态
   */
  @TableField("makeInvoiceStatus")
  private String makeInvoiceStatus;

  /**
   * 发票种类
   */
  @TableField("invoiceType")
  private String invoiceType;

  /**
   * 抬头类型
   */
  @TableField("headerType")
  private String headerType;

  /**
   * 是否强制开票
   */
  @TableField("forceInvoice")
  private String forceInvoice;

  /**
   * 开票金额
   */
  @TableField("invoiceAmount")
  private BigDecimal invoiceAmount;

  /**
   * 结算金额
   */
  @TableField("settlementAmount")
  private BigDecimal settlementAmount;

  /**
   * 开票金额与结算金额是否一致
   */
  @TableField("isConsistent")
  private String isConsistent;

  /**
   * 金额校验差额
   */
  @TableField("verificationVariance")
  private BigDecimal verificationVariance;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("applyNo", applyNo);
      map.put("storeId", storeId);
      map.put("storeName", storeName);
      map.put("mainOrderNo", mainOrderNo);
      map.put("businessType", businessType);
      map.put("orderType", orderType);
      map.put("purchaserName", purchaserName);
      map.put("purchaserTaxNo", purchaserTaxNo);
      map.put("purchaserAddress", purchaserAddress);
      map.put("purchaserTel", purchaserTel);
      map.put("purchaserBankName", purchaserBankName);
      map.put("purchaserBankAccount", purchaserBankAccount);
      map.put("applyType", applyType);
      map.put("applyTime", BocpGenUtils.toTimestamp(applyTime));
      map.put("settlementStatus", settlementStatus);
      map.put("makeInvoiceStatus", makeInvoiceStatus);
      map.put("invoiceType", invoiceType);
      map.put("headerType", headerType);
      map.put("forceInvoice", forceInvoice);
      map.put("invoiceAmount", invoiceAmount);
      map.put("settlementAmount", settlementAmount);
      map.put("isConsistent", isConsistent);
      map.put("verificationVariance", verificationVariance);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      return map;
  }

  public static OrderMainSubmit fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    OrderMainSubmit entity = new OrderMainSubmit();
    if(map.containsKey("applyNo")) {
      Object obj = map.get("applyNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeId")) {
      Object obj = map.get("storeId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStoreId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("storeName")) {
      Object obj = map.get("storeName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStoreName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("mainOrderNo")) {
      Object obj = map.get("mainOrderNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMainOrderNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("businessType")) {
      Object obj = map.get("businessType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBusinessType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderType")) {
      Object obj = map.get("orderType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserName")) {
      Object obj = map.get("purchaserName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTaxNo")) {
      Object obj = map.get("purchaserTaxNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTaxNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserAddress")) {
      Object obj = map.get("purchaserAddress");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserAddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserTel")) {
      Object obj = map.get("purchaserTel");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserTel((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankName")) {
      Object obj = map.get("purchaserBankName");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserBankName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("purchaserBankAccount")) {
      Object obj = map.get("purchaserBankAccount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPurchaserBankAccount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyType")) {
      Object obj = map.get("applyType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setApplyType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("applyTime")) {
      Object obj = map.get("applyTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setApplyTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setApplyTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setApplyTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setApplyTime(null);
      }
    }
    if(map.containsKey("settlementStatus")) {
      Object obj = map.get("settlementStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSettlementStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("makeInvoiceStatus")) {
      Object obj = map.get("makeInvoiceStatus");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMakeInvoiceStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceType")) {
      Object obj = map.get("invoiceType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoiceType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("headerType")) {
      Object obj = map.get("headerType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setHeaderType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("forceInvoice")) {
      Object obj = map.get("forceInvoice");
      if(obj != null) {
        if(obj instanceof String){
          entity.setForceInvoice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoiceAmount")) {
      Object obj = map.get("invoiceAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setInvoiceAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setInvoiceAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setInvoiceAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setInvoiceAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setInvoiceAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("settlementAmount")) {
      Object obj = map.get("settlementAmount");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setSettlementAmount((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setSettlementAmount(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setSettlementAmount(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setSettlementAmount(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setSettlementAmount(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("isConsistent")) {
      Object obj = map.get("isConsistent");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsConsistent((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("verificationVariance")) {
      Object obj = map.get("verificationVariance");
      if(obj != null) {
        if(obj instanceof BigDecimal) {
          entity.setVerificationVariance((BigDecimal)obj);
        } else if(obj instanceof Long) {
          entity.setVerificationVariance(BigDecimal.valueOf((Long)obj));
        } else if(obj instanceof Double) {
          entity.setVerificationVariance(BigDecimal.valueOf((Double)obj));
        } else if(obj instanceof String) {
          entity.setVerificationVariance(new BigDecimal((String)obj));
        } else if(obj instanceof Integer) {
          entity.setVerificationVariance(BigDecimal.valueOf(Long.parseLong(obj.toString())));
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    return entity;
  }
}
