package com.xforceplus.ultraman.app.jcunilever.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 待办对象
 * </p>
 *
 * @author ultraman
 * @since 2023-03-16
 */
public enum ProduceObj {

    PUSH_BILLING("PushBilling", "推送billing单据"),
    PUSH_MDM("PushMdm", "推送mdm");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ProduceObj(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProduceObj fromCode(String code){
        switch(code) {
            case "PushBilling":
                return PUSH_BILLING;
            case "PushMdm":
                return PUSH_MDM;
            default:
                return null;
        }
    }
}
