package com.xforceplus.ultraman.app.jcunilever.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-03-16
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BillingHead implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * billing单编号
   */
  private String billingdocument;

  /**
   * 付款方编码
   */
  private String companycode;

  /**
   * 销售组织
   */
  private String salesorganization;

  /**
   * 付款人代码
   */
  private String payer;

  /**
   * 付款人名称
   */
  private String nameofpayer;

  /**
   * 交易方代码
   */
  private String soldtoparty;

  /**
   * 交易方名称
   */
  private String nameofsoldtoparty;

  /**
   * 客户组
   */
  private String keycustomer4name;

  /**
   * 参考凭证编号
   */
  private String referencedocumentn;

  /**
   * billing日期
   */
  private String billingdate;

  /**
   * billing类型
   */
  private String billingtype;

  /**
   * 不含税金额
   */
  private String netvalue;

  /**
   * 税额
   */
  private String taxamount;

  /**
   * PO编号
   */
  private String ponumber;

  /**
   * 红字通知单编号
   */
  private String redivnoticeno;

  /**
   * 原始数据处理状态
   */
  private String status;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("billingdocument", billingdocument);
      map.put("companycode", companycode);
      map.put("salesorganization", salesorganization);
      map.put("payer", payer);
      map.put("nameofpayer", nameofpayer);
      map.put("soldtoparty", soldtoparty);
      map.put("nameofsoldtoparty", nameofsoldtoparty);
      map.put("keycustomer4name", keycustomer4name);
      map.put("referencedocumentn", referencedocumentn);
      map.put("billingdate", billingdate);
      map.put("billingtype", billingtype);
      map.put("netvalue", netvalue);
      map.put("taxamount", taxamount);
      map.put("ponumber", ponumber);
      map.put("redivnoticeno", redivnoticeno);
      map.put("status", status);
      return map;
  }

  public static BillingHead fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    BillingHead entity = new BillingHead();
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingdocument")) {
      Object obj = map.get("billingdocument");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillingdocument((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companycode")) {
      Object obj = map.get("companycode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanycode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesorganization")) {
      Object obj = map.get("salesorganization");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalesorganization((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payer")) {
      Object obj = map.get("payer");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("nameofpayer")) {
      Object obj = map.get("nameofpayer");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNameofpayer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("soldtoparty")) {
      Object obj = map.get("soldtoparty");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSoldtoparty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("nameofsoldtoparty")) {
      Object obj = map.get("nameofsoldtoparty");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNameofsoldtoparty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("keycustomer4name")) {
      Object obj = map.get("keycustomer4name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setKeycustomer4name((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("referencedocumentn")) {
      Object obj = map.get("referencedocumentn");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReferencedocumentn((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingdate")) {
      Object obj = map.get("billingdate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillingdate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingtype")) {
      Object obj = map.get("billingtype");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillingtype((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("netvalue")) {
      Object obj = map.get("netvalue");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNetvalue((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxamount")) {
      Object obj = map.get("taxamount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxamount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ponumber")) {
      Object obj = map.get("ponumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPonumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("redivnoticeno")) {
      Object obj = map.get("redivnoticeno");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRedivnoticeno((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billingdocument")) {
      Object obj = map.get("billingdocument");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillingdocument((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("companycode")) {
      Object obj = map.get("companycode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanycode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesorganization")) {
      Object obj = map.get("salesorganization");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesorganization((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("payer")) {
      Object obj = map.get("payer");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPayer((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("nameofpayer")) {
      Object obj = map.get("nameofpayer");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNameofpayer((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("soldtoparty")) {
      Object obj = map.get("soldtoparty");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSoldtoparty((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("nameofsoldtoparty")) {
      Object obj = map.get("nameofsoldtoparty");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNameofsoldtoparty((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("keycustomer4name")) {
      Object obj = map.get("keycustomer4name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setKeycustomer4name((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("referencedocumentn")) {
      Object obj = map.get("referencedocumentn");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReferencedocumentn((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billingdate")) {
      Object obj = map.get("billingdate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillingdate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billingtype")) {
      Object obj = map.get("billingtype");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillingtype((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("netvalue")) {
      Object obj = map.get("netvalue");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNetvalue((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxamount")) {
      Object obj = map.get("taxamount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxamount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ponumber")) {
      Object obj = map.get("ponumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPonumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("redivnoticeno")) {
      Object obj = map.get("redivnoticeno");
      if(obj != null) {
        if(obj instanceof String) {
          this.setRedivnoticeno((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStatus((String)obj);
        }
      } else {
      }
    }
  }
}
