package com.xforceplus.ultraman.app.jcunilever.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票业务状态
 * </p>
 *
 * @author ultraman
 * @since 2023-03-17
 */
public enum BusinessStatus {

    _0("0", "待处理"),
    _1("1", "已创建billing关系"),
    _2("2", "已生成发票文本txt"),
    _3("3", "已生成billing发票关系excel"),
    _99("99", "处理异常");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    BusinessStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static BusinessStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            case "2":
                return _2;
            case "3":
                return _3;
            case "99":
                return _99;
            default:
                return null;
        }
    }
}
