package com.xforceplus.ultraman.app.jcunilever.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 开票金额与结算金额是否一致
 * </p>
 *
 * @author ultraman
 * @since 2023-03-17
 */
public enum IsConsistent {

    _0("0", "一致"),
    _1("1", "不一致");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    IsConsistent(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static IsConsistent fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            default:
                return null;
        }
    }
}
