package com.xforceplus.ultraman.app.jcunilever.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 提交开票状态
 * </p>
 *
 * @author ultraman
 * @since 2023-03-17
 */
public enum SubmitInvoiceStatus {

    _0("0", "待上传"),
    _1("1", "上传异常");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    SubmitInvoiceStatus(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static SubmitInvoiceStatus fromCode(String code){
        switch(code) {
            case "0":
                return _0;
            case "1":
                return _1;
            default:
                return null;
        }
    }
}
