package com.xforceplus.ultraman.app.jcunilever.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 客户类型
 * </p>
 *
 * @author ultraman
 * @since 2023-03-20
 */
public enum CustomerType {

    KC("KC", "商超客户"),
    DT("DT", "经销商"),
    BRANCH("Branch", "内部公司");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    CustomerType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static CustomerType fromCode(String code){
        switch(code) {
            case "KC":
                return KC;
            case "DT":
                return DT;
            case "Branch":
                return BRANCH;
            default:
                return null;
        }
    }
}
