package com.xforceplus.ultraman.app.jcunilever.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 文件类型
 * </p>
 *
 * @author ultraman
 * @since 2023-03-20
 */
public enum FileType {

    BILLING("Billing", "发货凭证"),
    INVOICE_MATCH("InvoiceMatch", "配票凭证"),
    STATEMENT("Statement", "月度对账单"),
    OPEN_A_R("OpenAR", "未清凭证");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    FileType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static FileType fromCode(String code){
        switch(code) {
            case "Billing":
                return BILLING;
            case "InvoiceMatch":
                return INVOICE_MATCH;
            case "Statement":
                return STATEMENT;
            case "OpenAR":
                return OPEN_A_R;
            default:
                return null;
        }
    }
}
