package com.xforceplus.ultraman.app.jcunilever.dict;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 待办类型
 * </p>
 *
 * @author ultraman
 * @since 2023-03-20
 */
public enum ProduceType {

    PUSH_BILLING_ORDER_POOL("PushBillingOrderPool", "biiling推送统一单据池"),
    PUSH_BILLING_UNION("PushBillingUnion", "biiling推送商联对账"),
    PUSH_BILLING("PushBilling", "推送billing单据"),
    PUSH_MDM("PushMdm", "推送Mdm"),
    PUSH_MDM_CONFIG("PushMdmConfig", "推送Mdm配置"),
    PUSH_MDM_TRAVELLING("PushMdmTravelling", "推送Mdm客商"),
    PUSH_NO_INVOICE_INFO("PushNoInvoiceInfo", "推送billing不开票原因");

    @EnumValue
    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    ProduceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static ProduceType fromCode(String code){
        switch(code) {
            case "PushBillingOrderPool":
                return PUSH_BILLING_ORDER_POOL;
            case "PushBillingUnion":
                return PUSH_BILLING_UNION;
            case "PushBilling":
                return PUSH_BILLING;
            case "PushMdm":
                return PUSH_MDM;
            case "PushMdmConfig":
                return PUSH_MDM_CONFIG;
            case "PushMdmTravelling":
                return PUSH_MDM_TRAVELLING;
            case "PushNoInvoiceInfo":
                return PUSH_NO_INVOICE_INFO;
            default:
                return null;
        }
    }
}
