package com.xforceplus.ultraman.app.jcunilever.entity;

import java.time.LocalDateTime;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * <p>
 * 
 * </p>
 *
 * @author ultraman
 * @since 2023-03-20
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class BillingDetails implements Serializable {

  private static final long serialVersionUID=1L;

  /**
   * id
   */
  private Long id;

  /**
   * 租户ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long tenantId;

  /**
   * 租户代码
   */
  @TableField(fill = FieldFill.INSERT)
  private String tenantCode;

  /**
   * 创建时间
   */
  @TableField(fill = FieldFill.INSERT)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;

  /**
   * 修改时间
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;

  /**
   * 创建人ID
   */
  @TableField(fill = FieldFill.INSERT)
  private Long createUserId;

  /**
   * 修改人ID
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private Long updateUserId;

  /**
   * 创建人名字
   */
  @TableField(fill = FieldFill.INSERT)
  private String createUserName;

  /**
   * 修改人名字
   */
  @TableField(fill = FieldFill.INSERT_UPDATE)
  private String updateUserName;

  /**
   * 删除标记
   */
  @TableField(fill = FieldFill.INSERT)
  private String deleteFlag;

  /**
   * billing单编号
   */
  private String billingdocument;

  /**
   * billing单行编号
   */
  private String billingitem;

  /**
   * 公司代码
   */
  private String companycode;

  /**
   * 销售组织
   */
  private String salesorganization;

  /**
   * 收票方代码
   */
  private String billtoparty;

  /**
   * 收票方名称
   */
  private String nameofbilltopart;

  /**
   * 销售员编码
   */
  private String localsalesworkforcel4;

  /**
   * EMS编码
   */
  private String emscode;

  /**
   * 客户组
   */
  private String keycustomer4name;

  /**
   * 关联外向交货单号
   */
  private String referenceobd;

  /**
   * billing日期
   */
  private String billingdate;

  /**
   * billing类型
   */
  private String billingtype;

  /**
   * po编号
   */
  private String ponumber;

  /**
   * 编号
   */
  private String salesdoc;

  /**
   * 客户商品编码
   */
  private String matnumusedcustomer;

  /**
   * 过账状态
   */
  private String status;

  /**
   * 不含税金额
   */
  private String netvalue;

  /**
   * 税额
   */
  private String tax;

  /**
   * 含税金额
   */
  private String netvaluetax;

  /**
   * originalboxprice不含税金额
   */
  private String originalboxprice;

  /**
   * publish价格
   */
  private String publishprice;

  /**
   * 合同编号
   */
  private String salesdeal;

  /**
   * 客户商品描述
   */
  private String externaldescription;

  /**
   * ot折扣
   */
  private String otdiscount;

  /**
   * eot折扣
   */
  private String eotdiscount;

  /**
   * cpp折扣
   */
  private String cppdiscount;

  /**
   * aftereotot
   */
  private String aftereotot;

  /**
   * 内部订单
   */
  private String internalorder;

  /**
   * 商品
   */
  private String material;

  /**
   * 商品描述
   */
  private String materialdescription;

  /**
   * 开票数量
   */
  private String invoicedqty;

  /**
   * 单位
   */
  private String salesunit;

  /**
   * 发货仓库
   */
  private String plant;

  /**
   * 购方税号
   */
  private String vatregistrationno;

  /**
   * 增值税率
   */
  private String taxrate;

  /**
   * 不含税金额1
   */
  private String netprice1;

  /**
   * 不含税金额2
   */
  private String netprice2;

  /**
   * 固定折扣及票折
   */
  private String discount;

  /**
   * 净开票金额（不含税）
   */
  private String netinvoice;

  /**
   * 备注
   */
  private String notes;

  /**
   * commoditycode
   */
  private String commoditycode;

  /**
   * customertelno
   */
  private String customertelno;

  /**
   * customeraddress
   */
  private String customeraddress;

  /**
   * 银行名称
   */
  private String bankname;

  /**
   * 银行账号No
   */
  private String bankaccountno;

  /**
   * statusfortransfer
   */
  private String statusfortransfer;

  /**
   * gtxinvoicecode
   */
  private String gtxinvoicecode;

  /**
   * goldentaxissuedate
   */
  private String goldentaxissuedate;




  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("billingdocument", billingdocument);
      map.put("billingitem", billingitem);
      map.put("companycode", companycode);
      map.put("salesorganization", salesorganization);
      map.put("billtoparty", billtoparty);
      map.put("nameofbilltopart", nameofbilltopart);
      map.put("localsalesworkforcel4", localsalesworkforcel4);
      map.put("emscode", emscode);
      map.put("keycustomer4name", keycustomer4name);
      map.put("referenceobd", referenceobd);
      map.put("billingdate", billingdate);
      map.put("billingtype", billingtype);
      map.put("ponumber", ponumber);
      map.put("salesdoc", salesdoc);
      map.put("matnumusedcustomer", matnumusedcustomer);
      map.put("status", status);
      map.put("netvalue", netvalue);
      map.put("tax", tax);
      map.put("netvaluetax", netvaluetax);
      map.put("originalboxprice", originalboxprice);
      map.put("publishprice", publishprice);
      map.put("salesdeal", salesdeal);
      map.put("externaldescription", externaldescription);
      map.put("otdiscount", otdiscount);
      map.put("eotdiscount", eotdiscount);
      map.put("cppdiscount", cppdiscount);
      map.put("aftereotot", aftereotot);
      map.put("internalorder", internalorder);
      map.put("material", material);
      map.put("materialdescription", materialdescription);
      map.put("invoicedqty", invoicedqty);
      map.put("salesunit", salesunit);
      map.put("plant", plant);
      map.put("vatregistrationno", vatregistrationno);
      map.put("taxrate", taxrate);
      map.put("netprice1", netprice1);
      map.put("netprice2", netprice2);
      map.put("discount", discount);
      map.put("netinvoice", netinvoice);
      map.put("notes", notes);
      map.put("commoditycode", commoditycode);
      map.put("customertelno", customertelno);
      map.put("customeraddress", customeraddress);
      map.put("bankname", bankname);
      map.put("bankaccountno", bankaccountno);
      map.put("statusfortransfer", statusfortransfer);
      map.put("gtxinvoicecode", gtxinvoicecode);
      map.put("goldentaxissuedate", goldentaxissuedate);
      return map;
  }

  public static BillingDetails fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    BillingDetails entity = new BillingDetails();
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingdocument")) {
      Object obj = map.get("billingdocument");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillingdocument((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingitem")) {
      Object obj = map.get("billingitem");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillingitem((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("companycode")) {
      Object obj = map.get("companycode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCompanycode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesorganization")) {
      Object obj = map.get("salesorganization");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalesorganization((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billtoparty")) {
      Object obj = map.get("billtoparty");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBilltoparty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("nameofbilltopart")) {
      Object obj = map.get("nameofbilltopart");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNameofbilltopart((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("localsalesworkforcel4")) {
      Object obj = map.get("localsalesworkforcel4");
      if(obj != null) {
        if(obj instanceof String){
          entity.setLocalsalesworkforcel4((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("emscode")) {
      Object obj = map.get("emscode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEmscode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("keycustomer4name")) {
      Object obj = map.get("keycustomer4name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setKeycustomer4name((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("referenceobd")) {
      Object obj = map.get("referenceobd");
      if(obj != null) {
        if(obj instanceof String){
          entity.setReferenceobd((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingdate")) {
      Object obj = map.get("billingdate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillingdate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("billingtype")) {
      Object obj = map.get("billingtype");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBillingtype((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ponumber")) {
      Object obj = map.get("ponumber");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPonumber((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesdoc")) {
      Object obj = map.get("salesdoc");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalesdoc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("matnumusedcustomer")) {
      Object obj = map.get("matnumusedcustomer");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMatnumusedcustomer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatus((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("netvalue")) {
      Object obj = map.get("netvalue");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNetvalue((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tax")) {
      Object obj = map.get("tax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("netvaluetax")) {
      Object obj = map.get("netvaluetax");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNetvaluetax((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("originalboxprice")) {
      Object obj = map.get("originalboxprice");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOriginalboxprice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("publishprice")) {
      Object obj = map.get("publishprice");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPublishprice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesdeal")) {
      Object obj = map.get("salesdeal");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalesdeal((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("externaldescription")) {
      Object obj = map.get("externaldescription");
      if(obj != null) {
        if(obj instanceof String){
          entity.setExternaldescription((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("otdiscount")) {
      Object obj = map.get("otdiscount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOtdiscount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("eotdiscount")) {
      Object obj = map.get("eotdiscount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setEotdiscount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("cppdiscount")) {
      Object obj = map.get("cppdiscount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCppdiscount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("aftereotot")) {
      Object obj = map.get("aftereotot");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAftereotot((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("internalorder")) {
      Object obj = map.get("internalorder");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInternalorder((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("material")) {
      Object obj = map.get("material");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterial((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("materialdescription")) {
      Object obj = map.get("materialdescription");
      if(obj != null) {
        if(obj instanceof String){
          entity.setMaterialdescription((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("invoicedqty")) {
      Object obj = map.get("invoicedqty");
      if(obj != null) {
        if(obj instanceof String){
          entity.setInvoicedqty((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("salesunit")) {
      Object obj = map.get("salesunit");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSalesunit((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("plant")) {
      Object obj = map.get("plant");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPlant((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("vatregistrationno")) {
      Object obj = map.get("vatregistrationno");
      if(obj != null) {
        if(obj instanceof String){
          entity.setVatregistrationno((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("taxrate")) {
      Object obj = map.get("taxrate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTaxrate((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("netprice1")) {
      Object obj = map.get("netprice1");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNetprice1((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("netprice2")) {
      Object obj = map.get("netprice2");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNetprice2((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("discount")) {
      Object obj = map.get("discount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDiscount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("netinvoice")) {
      Object obj = map.get("netinvoice");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNetinvoice((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("notes")) {
      Object obj = map.get("notes");
      if(obj != null) {
        if(obj instanceof String){
          entity.setNotes((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("commoditycode")) {
      Object obj = map.get("commoditycode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCommoditycode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customertelno")) {
      Object obj = map.get("customertelno");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustomertelno((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("customeraddress")) {
      Object obj = map.get("customeraddress");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCustomeraddress((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bankname")) {
      Object obj = map.get("bankname");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBankname((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("bankaccountno")) {
      Object obj = map.get("bankaccountno");
      if(obj != null) {
        if(obj instanceof String){
          entity.setBankaccountno((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("statusfortransfer")) {
      Object obj = map.get("statusfortransfer");
      if(obj != null) {
        if(obj instanceof String){
          entity.setStatusfortransfer((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("gtxinvoicecode")) {
      Object obj = map.get("gtxinvoicecode");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGtxinvoicecode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goldentaxissuedate")) {
      Object obj = map.get("goldentaxissuedate");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGoldentaxissuedate((String)obj);
        }
      } else{
      }
    }
    return entity;
  }


  protected void setByOQSMap(Map map) {
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setId((Long)obj);
        } else if(obj instanceof String) {
          this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTenantCode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime) {
          this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else {
        this.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer) {
          this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else {
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCreateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setUpdateUserName((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDeleteFlag((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billingdocument")) {
      Object obj = map.get("billingdocument");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillingdocument((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billingitem")) {
      Object obj = map.get("billingitem");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillingitem((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("companycode")) {
      Object obj = map.get("companycode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCompanycode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesorganization")) {
      Object obj = map.get("salesorganization");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesorganization((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billtoparty")) {
      Object obj = map.get("billtoparty");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBilltoparty((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("nameofbilltopart")) {
      Object obj = map.get("nameofbilltopart");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNameofbilltopart((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("localsalesworkforcel4")) {
      Object obj = map.get("localsalesworkforcel4");
      if(obj != null) {
        if(obj instanceof String) {
          this.setLocalsalesworkforcel4((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("emscode")) {
      Object obj = map.get("emscode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEmscode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("keycustomer4name")) {
      Object obj = map.get("keycustomer4name");
      if(obj != null) {
        if(obj instanceof String) {
          this.setKeycustomer4name((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("referenceobd")) {
      Object obj = map.get("referenceobd");
      if(obj != null) {
        if(obj instanceof String) {
          this.setReferenceobd((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billingdate")) {
      Object obj = map.get("billingdate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillingdate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("billingtype")) {
      Object obj = map.get("billingtype");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBillingtype((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("ponumber")) {
      Object obj = map.get("ponumber");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPonumber((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesdoc")) {
      Object obj = map.get("salesdoc");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesdoc((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("matnumusedcustomer")) {
      Object obj = map.get("matnumusedcustomer");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMatnumusedcustomer((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("status")) {
      Object obj = map.get("status");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStatus((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("netvalue")) {
      Object obj = map.get("netvalue");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNetvalue((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("tax")) {
      Object obj = map.get("tax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("netvaluetax")) {
      Object obj = map.get("netvaluetax");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNetvaluetax((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("originalboxprice")) {
      Object obj = map.get("originalboxprice");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOriginalboxprice((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("publishprice")) {
      Object obj = map.get("publishprice");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPublishprice((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesdeal")) {
      Object obj = map.get("salesdeal");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesdeal((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("externaldescription")) {
      Object obj = map.get("externaldescription");
      if(obj != null) {
        if(obj instanceof String) {
          this.setExternaldescription((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("otdiscount")) {
      Object obj = map.get("otdiscount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setOtdiscount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("eotdiscount")) {
      Object obj = map.get("eotdiscount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setEotdiscount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("cppdiscount")) {
      Object obj = map.get("cppdiscount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCppdiscount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("aftereotot")) {
      Object obj = map.get("aftereotot");
      if(obj != null) {
        if(obj instanceof String) {
          this.setAftereotot((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("internalorder")) {
      Object obj = map.get("internalorder");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInternalorder((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("material")) {
      Object obj = map.get("material");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMaterial((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("materialdescription")) {
      Object obj = map.get("materialdescription");
      if(obj != null) {
        if(obj instanceof String) {
          this.setMaterialdescription((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("invoicedqty")) {
      Object obj = map.get("invoicedqty");
      if(obj != null) {
        if(obj instanceof String) {
          this.setInvoicedqty((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("salesunit")) {
      Object obj = map.get("salesunit");
      if(obj != null) {
        if(obj instanceof String) {
          this.setSalesunit((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("plant")) {
      Object obj = map.get("plant");
      if(obj != null) {
        if(obj instanceof String) {
          this.setPlant((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("vatregistrationno")) {
      Object obj = map.get("vatregistrationno");
      if(obj != null) {
        if(obj instanceof String) {
          this.setVatregistrationno((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("taxrate")) {
      Object obj = map.get("taxrate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setTaxrate((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("netprice1")) {
      Object obj = map.get("netprice1");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNetprice1((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("netprice2")) {
      Object obj = map.get("netprice2");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNetprice2((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("discount")) {
      Object obj = map.get("discount");
      if(obj != null) {
        if(obj instanceof String) {
          this.setDiscount((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("netinvoice")) {
      Object obj = map.get("netinvoice");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNetinvoice((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("notes")) {
      Object obj = map.get("notes");
      if(obj != null) {
        if(obj instanceof String) {
          this.setNotes((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("commoditycode")) {
      Object obj = map.get("commoditycode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCommoditycode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customertelno")) {
      Object obj = map.get("customertelno");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomertelno((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("customeraddress")) {
      Object obj = map.get("customeraddress");
      if(obj != null) {
        if(obj instanceof String) {
          this.setCustomeraddress((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bankname")) {
      Object obj = map.get("bankname");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBankname((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("bankaccountno")) {
      Object obj = map.get("bankaccountno");
      if(obj != null) {
        if(obj instanceof String) {
          this.setBankaccountno((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("statusfortransfer")) {
      Object obj = map.get("statusfortransfer");
      if(obj != null) {
        if(obj instanceof String) {
          this.setStatusfortransfer((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("gtxinvoicecode")) {
      Object obj = map.get("gtxinvoicecode");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGtxinvoicecode((String)obj);
        }
      } else {
      }
    }
    if(map.containsKey("goldentaxissuedate")) {
      Object obj = map.get("goldentaxissuedate");
      if(obj != null) {
        if(obj instanceof String) {
          this.setGoldentaxissuedate((String)obj);
        }
      } else {
      }
    }
  }
}
