package com.xforceplus.ultraman.app.jcunilever.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 发票种类
 * </p>
 *
 * @author ultraman
 * @since 2022-05-09
 */
public enum InvoiceType {

    CE("ce", "增值税电子普通发票"),
    SE("se", "增值税电子专用发票");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    InvoiceType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static InvoiceType fromCode(String code){
        switch(code) {
            case "ce":
                return CE;
            case "se":
                return SE;
            default:
                return null;
        }
    }
}
