package com.xforceplus.ultraman.app.jcunilever.metadata.entity;

import java.time.LocalDateTime;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.io.Serializable;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.xforceplus.ultraman.bocp.gen.util.BocpGenUtils;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

/**
 * <p>
 * settlement_pool
 * </p>
 *
 * @author ultraman
 * @since 2022-05-09
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
public class SettlementPool implements Serializable {

  private static final long serialVersionUID=1L;
  /**
   * 结算单号
   */
  private String requestNo;
  /**
   * 订单号
   */
  private String shopOrderId;
  /**
   * 子订单号
   */
  private String orderId;
  /**
   * 商家实收（分）
   */
  private String settleAmount;
  /**
   * 货款结算对应的账户类型
   */
  private String payTypeDesc;
  /**
   * 结算单类型
   */
  private String tradeType;
  /**
   * 是否包含结算前退款
   */
  private String isContainsRefundBeforeSettle;
  /**
   * 商品ID
   */
  private String productId;
  /**
   * 商品数量
   */
  private String goodsCount;
  /**
   * 业务类型
   */
  private String flowTypeDesc;
  /**
   * 订单类型
   */
  private String orderType;
  /**
   * 订单总价（分）
   */
  private String totalAmount;
  /**
   * 商品总价（分）
   */
  private String totalGoodsAmount;
  /**
   * id
   */
  private Long id;
  /**
   * 租户ID
   */
  private Long tenantId;
  /**
   * 租户代码
   */
  private String tenantCode;
  /**
   * 创建时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime createTime;
  /**
   * 修改时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime updateTime;
  /**
   * 创建人ID
   */
  private Long createUserId;
  /**
   * 修改人ID
   */
  private Long updateUserId;
  /**
   * 创建人名字
   */
  private String createUserName;
  /**
   * 修改人名字
   */
  private String updateUserName;
  /**
   * 删除标记
   */
  private String deleteFlag;
  /**
   * 运费（分）
   */
  private String postAmount;
  /**
   * 店铺券（分）
   */
  private String shopCoupon;
  /**
   * 结算前退款金额（分）
   */
  private String refundBeforeSettle;
  /**
   * 平台补贴（分）
   */
  private String platformCoupon;
  /**
   * 达人补贴（分）
   */
  private String authorCoupon;
  /**
   * 抖音支付补贴（分）
   */
  private String ztPayPromotion;
  /**
   * DOU分期营销补贴（分）
   */
  private String zrPayPromotion;
  /**
   * 用户实付（分）
   */
  private String realPayAmount;
  /**
   * 收入合计（分）
   */
  private String totalIncome;
  /**
   * 平台服务费（分）
   */
  private String platformServiceFee;
  /**
   * 佣金（分）
   */
  private String commission;
  /**
   * 渠道分成（分）
   */
  private String goodLearnChannelFee;
  /**
   * 团长服务费（分）
   */
  private String colonelServiceFee;
  /**
   * 直播间站外推广（分）
   */
  private String channelPromotionFee;
  /**
   * 其他分成(学浪)（分）
   */
  private String otherSharingAmount;
  /**
   * 总支出(分)
   */
  private String totalOutcome;
  /**
   * 备注
   */
  private String remark;
  /**
   * 结算时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime settleTime;
  /**
   * 下单时间
   */
  @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private LocalDateTime orderTime;
  /**
   * 数据来源
   */
  private String dataOrig;


  public Map toOQSMap(){
      Map map = new HashMap();
      map.put("requestNo", requestNo);
      map.put("shopOrderId", shopOrderId);
      map.put("orderId", orderId);
      map.put("settleAmount", settleAmount);
      map.put("payTypeDesc", payTypeDesc);
      map.put("tradeType", tradeType);
      map.put("isContainsRefundBeforeSettle", isContainsRefundBeforeSettle);
      map.put("productId", productId);
      map.put("goodsCount", goodsCount);
      map.put("flowTypeDesc", flowTypeDesc);
      map.put("orderType", orderType);
      map.put("totalAmount", totalAmount);
      map.put("totalGoodsAmount", totalGoodsAmount);
      map.put("id", id);
      map.put("tenant_id", tenantId);
      map.put("tenant_code", tenantCode);
      map.put("create_time", BocpGenUtils.toTimestamp(createTime));
      map.put("update_time", BocpGenUtils.toTimestamp(updateTime));
      map.put("create_user_id", createUserId);
      map.put("update_user_id", updateUserId);
      map.put("create_user_name", createUserName);
      map.put("update_user_name", updateUserName);
      map.put("delete_flag", deleteFlag);
      map.put("postAmount", postAmount);
      map.put("shopCoupon", shopCoupon);
      map.put("refundBeforeSettle", refundBeforeSettle);
      map.put("platformCoupon", platformCoupon);
      map.put("authorCoupon", authorCoupon);
      map.put("ztPayPromotion", ztPayPromotion);
      map.put("zrPayPromotion", zrPayPromotion);
      map.put("realPayAmount", realPayAmount);
      map.put("totalIncome", totalIncome);
      map.put("platformServiceFee", platformServiceFee);
      map.put("commission", commission);
      map.put("goodLearnChannelFee", goodLearnChannelFee);
      map.put("colonelServiceFee", colonelServiceFee);
      map.put("channelPromotionFee", channelPromotionFee);
      map.put("otherSharingAmount", otherSharingAmount);
      map.put("total_outcome", totalOutcome);
      map.put("remark", remark);
      map.put("settleTime", BocpGenUtils.toTimestamp(settleTime));
      map.put("orderTime", BocpGenUtils.toTimestamp(orderTime));
      map.put("dataOrig", dataOrig);

      return map;
  }

  public static SettlementPool fromOQSMap(Map map){
    if(map == null || map.isEmpty()) {
      return null;
    }
    SettlementPool entity = new SettlementPool();

    if(map.containsKey("requestNo")) {
      Object obj = map.get("requestNo");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRequestNo((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shopOrderId")) {
      Object obj = map.get("shopOrderId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setShopOrderId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderId")) {
      Object obj = map.get("orderId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settleAmount")) {
      Object obj = map.get("settleAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setSettleAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("payTypeDesc")) {
      Object obj = map.get("payTypeDesc");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPayTypeDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("tradeType")) {
      Object obj = map.get("tradeType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTradeType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("isContainsRefundBeforeSettle")) {
      Object obj = map.get("isContainsRefundBeforeSettle");
      if(obj != null) {
        if(obj instanceof String){
          entity.setIsContainsRefundBeforeSettle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("productId")) {
      Object obj = map.get("productId");
      if(obj != null) {
        if(obj instanceof String){
          entity.setProductId((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goodsCount")) {
      Object obj = map.get("goodsCount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGoodsCount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("flowTypeDesc")) {
      Object obj = map.get("flowTypeDesc");
      if(obj != null) {
        if(obj instanceof String){
          entity.setFlowTypeDesc((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("orderType")) {
      Object obj = map.get("orderType");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOrderType((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalAmount")) {
      Object obj = map.get("totalAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTotalAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalGoodsAmount")) {
      Object obj = map.get("totalGoodsAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTotalGoodsAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setId((Long)obj);
        } else if(obj instanceof String) {
          entity.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setTenantId((Long)obj);
        } else if(obj instanceof String) {
          entity.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTenantCode((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setCreateTime(null);
      }
    }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setUpdateTime(null);
      }
    }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
          entity.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
          entity.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
    }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCreateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
          entity.setUpdateUserName((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDeleteFlag((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("postAmount")) {
      Object obj = map.get("postAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPostAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("shopCoupon")) {
      Object obj = map.get("shopCoupon");
      if(obj != null) {
        if(obj instanceof String){
          entity.setShopCoupon((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("refundBeforeSettle")) {
      Object obj = map.get("refundBeforeSettle");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRefundBeforeSettle((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("platformCoupon")) {
      Object obj = map.get("platformCoupon");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPlatformCoupon((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("authorCoupon")) {
      Object obj = map.get("authorCoupon");
      if(obj != null) {
        if(obj instanceof String){
          entity.setAuthorCoupon((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("ztPayPromotion")) {
      Object obj = map.get("ztPayPromotion");
      if(obj != null) {
        if(obj instanceof String){
          entity.setZtPayPromotion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("zrPayPromotion")) {
      Object obj = map.get("zrPayPromotion");
      if(obj != null) {
        if(obj instanceof String){
          entity.setZrPayPromotion((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("realPayAmount")) {
      Object obj = map.get("realPayAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRealPayAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("totalIncome")) {
      Object obj = map.get("totalIncome");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTotalIncome((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("platformServiceFee")) {
      Object obj = map.get("platformServiceFee");
      if(obj != null) {
        if(obj instanceof String){
          entity.setPlatformServiceFee((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("commission")) {
      Object obj = map.get("commission");
      if(obj != null) {
        if(obj instanceof String){
          entity.setCommission((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("goodLearnChannelFee")) {
      Object obj = map.get("goodLearnChannelFee");
      if(obj != null) {
        if(obj instanceof String){
          entity.setGoodLearnChannelFee((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("colonelServiceFee")) {
      Object obj = map.get("colonelServiceFee");
      if(obj != null) {
        if(obj instanceof String){
          entity.setColonelServiceFee((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("channelPromotionFee")) {
      Object obj = map.get("channelPromotionFee");
      if(obj != null) {
        if(obj instanceof String){
          entity.setChannelPromotionFee((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("otherSharingAmount")) {
      Object obj = map.get("otherSharingAmount");
      if(obj != null) {
        if(obj instanceof String){
          entity.setOtherSharingAmount((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("total_outcome")) {
      Object obj = map.get("total_outcome");
      if(obj != null) {
        if(obj instanceof String){
          entity.setTotalOutcome((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
          entity.setRemark((String)obj);
        }
      } else{
      }
    }
    if(map.containsKey("settleTime")) {
      Object obj = map.get("settleTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setSettleTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setSettleTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setSettleTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setSettleTime(null);
      }
    }
    if(map.containsKey("orderTime")) {
      Object obj = map.get("orderTime");
      if(obj != null) {
        if(obj instanceof Long) {
          entity.setOrderTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
          entity.setOrderTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
          entity.setOrderTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        entity.setOrderTime(null);
      }
    }
    if(map.containsKey("dataOrig")) {
      Object obj = map.get("dataOrig");
      if(obj != null) {
        if(obj instanceof String){
          entity.setDataOrig((String)obj);
        }
      } else{
      }
    }

    return entity;
  }


  protected void setByOQSMap(Map map){
    if(map.containsKey("requestNo")) {
      Object obj = map.get("requestNo");
      if(obj != null) {
        if(obj instanceof String){
            this.setRequestNo((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("shopOrderId")) {
      Object obj = map.get("shopOrderId");
      if(obj != null) {
        if(obj instanceof String){
            this.setShopOrderId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("orderId")) {
      Object obj = map.get("orderId");
      if(obj != null) {
        if(obj instanceof String){
            this.setOrderId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("settleAmount")) {
      Object obj = map.get("settleAmount");
      if(obj != null) {
        if(obj instanceof String){
            this.setSettleAmount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("payTypeDesc")) {
      Object obj = map.get("payTypeDesc");
      if(obj != null) {
        if(obj instanceof String){
            this.setPayTypeDesc((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("tradeType")) {
      Object obj = map.get("tradeType");
      if(obj != null) {
        if(obj instanceof String){
            this.setTradeType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("isContainsRefundBeforeSettle")) {
      Object obj = map.get("isContainsRefundBeforeSettle");
      if(obj != null) {
        if(obj instanceof String){
            this.setIsContainsRefundBeforeSettle((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("productId")) {
      Object obj = map.get("productId");
      if(obj != null) {
        if(obj instanceof String){
            this.setProductId((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("goodsCount")) {
      Object obj = map.get("goodsCount");
      if(obj != null) {
        if(obj instanceof String){
            this.setGoodsCount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("flowTypeDesc")) {
      Object obj = map.get("flowTypeDesc");
      if(obj != null) {
        if(obj instanceof String){
            this.setFlowTypeDesc((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("orderType")) {
      Object obj = map.get("orderType");
      if(obj != null) {
        if(obj instanceof String){
            this.setOrderType((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("totalAmount")) {
      Object obj = map.get("totalAmount");
      if(obj != null) {
        if(obj instanceof String){
            this.setTotalAmount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("totalGoodsAmount")) {
      Object obj = map.get("totalGoodsAmount");
      if(obj != null) {
        if(obj instanceof String){
            this.setTotalGoodsAmount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("id")) {
      Object obj = map.get("id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setId((Long)obj);
        } else if(obj instanceof String) {
            this.setId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_id")) {
      Object obj = map.get("tenant_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setTenantId((Long)obj);
        } else if(obj instanceof String) {
            this.setTenantId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setTenantId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("tenant_code")) {
      Object obj = map.get("tenant_code");
      if(obj != null) {
        if(obj instanceof String){
            this.setTenantCode((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("create_time")) {
      Object obj = map.get("create_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setCreateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setCreateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setCreateTime(null);
      }
   }
    if(map.containsKey("update_time")) {
      Object obj = map.get("update_time");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setUpdateTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setUpdateTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setUpdateTime(null);
      }
   }
    if(map.containsKey("create_user_id")) {
      Object obj = map.get("create_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setCreateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setCreateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setCreateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("update_user_id")) {
      Object obj = map.get("update_user_id");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setUpdateUserId((Long)obj);
        } else if(obj instanceof String) {
            this.setUpdateUserId(Long.parseLong((String)obj));
        } else if(obj instanceof Integer){
            this.setUpdateUserId(Long.parseLong(obj.toString()));
        }
      } else{
      }
   }
    if(map.containsKey("create_user_name")) {
      Object obj = map.get("create_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setCreateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("update_user_name")) {
      Object obj = map.get("update_user_name");
      if(obj != null) {
        if(obj instanceof String){
            this.setUpdateUserName((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("delete_flag")) {
      Object obj = map.get("delete_flag");
      if(obj != null) {
        if(obj instanceof String){
            this.setDeleteFlag((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("postAmount")) {
      Object obj = map.get("postAmount");
      if(obj != null) {
        if(obj instanceof String){
            this.setPostAmount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("shopCoupon")) {
      Object obj = map.get("shopCoupon");
      if(obj != null) {
        if(obj instanceof String){
            this.setShopCoupon((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("refundBeforeSettle")) {
      Object obj = map.get("refundBeforeSettle");
      if(obj != null) {
        if(obj instanceof String){
            this.setRefundBeforeSettle((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("platformCoupon")) {
      Object obj = map.get("platformCoupon");
      if(obj != null) {
        if(obj instanceof String){
            this.setPlatformCoupon((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("authorCoupon")) {
      Object obj = map.get("authorCoupon");
      if(obj != null) {
        if(obj instanceof String){
            this.setAuthorCoupon((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("ztPayPromotion")) {
      Object obj = map.get("ztPayPromotion");
      if(obj != null) {
        if(obj instanceof String){
            this.setZtPayPromotion((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("zrPayPromotion")) {
      Object obj = map.get("zrPayPromotion");
      if(obj != null) {
        if(obj instanceof String){
            this.setZrPayPromotion((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("realPayAmount")) {
      Object obj = map.get("realPayAmount");
      if(obj != null) {
        if(obj instanceof String){
            this.setRealPayAmount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("totalIncome")) {
      Object obj = map.get("totalIncome");
      if(obj != null) {
        if(obj instanceof String){
            this.setTotalIncome((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("platformServiceFee")) {
      Object obj = map.get("platformServiceFee");
      if(obj != null) {
        if(obj instanceof String){
            this.setPlatformServiceFee((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("commission")) {
      Object obj = map.get("commission");
      if(obj != null) {
        if(obj instanceof String){
            this.setCommission((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("goodLearnChannelFee")) {
      Object obj = map.get("goodLearnChannelFee");
      if(obj != null) {
        if(obj instanceof String){
            this.setGoodLearnChannelFee((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("colonelServiceFee")) {
      Object obj = map.get("colonelServiceFee");
      if(obj != null) {
        if(obj instanceof String){
            this.setColonelServiceFee((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("channelPromotionFee")) {
      Object obj = map.get("channelPromotionFee");
      if(obj != null) {
        if(obj instanceof String){
            this.setChannelPromotionFee((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("otherSharingAmount")) {
      Object obj = map.get("otherSharingAmount");
      if(obj != null) {
        if(obj instanceof String){
            this.setOtherSharingAmount((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("total_outcome")) {
      Object obj = map.get("total_outcome");
      if(obj != null) {
        if(obj instanceof String){
            this.setTotalOutcome((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("remark")) {
      Object obj = map.get("remark");
      if(obj != null) {
        if(obj instanceof String){
            this.setRemark((String)obj);
        }
      } else{
      }
   }
    if(map.containsKey("settleTime")) {
      Object obj = map.get("settleTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setSettleTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setSettleTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setSettleTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setSettleTime(null);
      }
   }
    if(map.containsKey("orderTime")) {
      Object obj = map.get("orderTime");
      if(obj != null) {
        if(obj instanceof Long) {
            this.setOrderTime(BocpGenUtils.toLocalDateTime((Long)obj));
        } else if(obj instanceof LocalDateTime){
            this.setOrderTime((LocalDateTime)obj);
        } else if(obj instanceof String) {
            this.setOrderTime(BocpGenUtils.toLocalDateTime(Long.parseLong((String)obj)));
        }
      } else{
        this.setOrderTime(null);
      }
   }
    if(map.containsKey("dataOrig")) {
      Object obj = map.get("dataOrig");
      if(obj != null) {
        if(obj instanceof String){
            this.setDataOrig((String)obj);
        }
      } else{
      }
   }

  }

}
