package com.xforceplus.ultraman.app.jcunilever.metadata.dict;


import com.fasterxml.jackson.annotation.JsonValue;

/**
 * <p>
 * 数据来源
 * </p>
 *
 * @author ultraman
 * @since 2022-05-23
 */
public enum DataOrig {

    _1("1", "接口传入"),
    _2("2", "页面导入");

    @JsonValue
    private final String code;

    private final String desc;

    public String getCode(){
        return this.code;
    }

    public String getDesc(){
        return this.desc;
    }

    public String code(){
        return this.code;
    }

    public String desc(){
        return this.desc;
    }

    DataOrig(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public String toString() {
        return this.code;
    }

    public static DataOrig fromCode(String code){
        switch(code) {
            case "1":
                return _1;
            case "2":
                return _2;
            default:
                return null;
        }
    }
}
